/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.utils;

import com.artillexstudios.axtrade.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axtrade.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axtrade.libs.axapi.utils.ItemBuilder;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilderUtil {
    @NotNull
    public static ItemBuilder newBuilder(@NotNull Section section, @Nullable Player player) {
        return ItemBuilderUtil.newBuilder(section, Map.of(), player);
    }

    @NotNull
    public static ItemBuilder newBuilder(@NotNull Section section, Map<String, String> replacements, @Nullable Player player) {
        ItemBuilder builder = ItemBuilder.create(section);
        section.getOptionalString("name").ifPresent(name -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                name = PlaceholderAPI.setPlaceholders((Player)player, (String)name);
            }
            builder.setName((String)name, replacements);
        });
        section.getOptionalStringList("lore").ifPresent(lore -> {
            if (ClassUtils.INSTANCE.classExists("me.clip.placeholderapi.PlaceholderAPI")) {
                lore = PlaceholderAPI.setPlaceholders((Player)player, (List)lore);
            }
            builder.setLore((List<String>)lore, replacements);
        });
        section.getOptionalString("texture").ifPresent(texture -> {
            for (Map.Entry entry : replacements.entrySet()) {
                texture = texture.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
            }
            builder.setTextureValue((String)texture);
        });
        return builder;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull ItemStack itemStack) {
        return ItemBuilder.create(itemStack);
    }
}

