/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.trade;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.api.events.AxTradeAbortEvent;
import com.artillexstudios.axtrade.api.events.AxTradeCompleteEvent;
import com.artillexstudios.axtrade.currency.CurrencyProcessor;
import com.artillexstudios.axtrade.hooks.currency.CurrencyHook;
import com.artillexstudios.axtrade.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axtrade.libs.axapi.utils.ContainerUtils;
import com.artillexstudios.axtrade.trade.TradePlayer;
import com.artillexstudios.axtrade.trade.Trades;
import com.artillexstudios.axtrade.utils.HistoryUtils;
import com.artillexstudios.axtrade.utils.NumberUtils;
import com.artillexstudios.axtrade.utils.SoundUtils;
import com.artillexstudios.axtrade.utils.TaxUtils;
import com.artillexstudios.axtrade.utils.Utils;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class Trade {
    protected final TradePlayer player1;
    protected final TradePlayer player2;
    private boolean ended = false;
    protected long prepTime = System.currentTimeMillis();

    public Trade(Player p1, Player p2) {
        this.player1 = new TradePlayer(this, p1);
        this.player2 = new TradePlayer(this, p2);
        this.player1.setOtherPlayer(this.player2);
        this.player2.setOtherPlayer(this.player1);
        HistoryUtils.writeToHistory(String.format("Started: %s - %s", this.player1.getPlayer().getName(), this.player2.getPlayer().getName()));
    }

    public void update() {
        this.player1.getTradeGui().update();
        this.player2.getTradeGui().update();
    }

    public void end() {
        this.ended = true;
        Scheduler.get().run(scheduledTask -> Trades.removeTrade(this));
        this.player1.getPlayer().closeInventory();
        this.player1.getPlayer().updateInventory();
        this.player2.getPlayer().closeInventory();
        this.player2.getPlayer().updateInventory();
    }

    public void abort() {
        this.abort(false);
    }

    public void abort(boolean force) {
        if (!force && this.ended) {
            return;
        }
        AxTradeAbortEvent event = new AxTradeAbortEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        this.end();
        this.player1.getTradeGui().getItems(false).forEach(itemStack -> {
            if (itemStack == null) {
                return;
            }
            this.player1.getPlayer().getInventory().addItem(new ItemStack[]{itemStack});
        });
        if (this.player2.getTradeGui() != null) {
            this.player2.getTradeGui().getItems(false).forEach(itemStack -> {
                if (itemStack == null) {
                    return;
                }
                this.player2.getPlayer().getInventory().addItem(new ItemStack[]{itemStack});
            });
        }
        HistoryUtils.writeToHistory(String.format("Aborted: %s - %s", this.player1.getPlayer().getName(), this.player2.getPlayer().getName()));
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player1.getPlayer(), "trade.aborted", Map.of("%player%", this.player2.getPlayer().getName()));
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player2.getPlayer(), "trade.aborted", Map.of("%player%", this.player1.getPlayer().getName()));
        SoundUtils.playSound(this.player1.getPlayer(), "aborted");
        SoundUtils.playSound(this.player2.getPlayer(), "aborted");
    }

    public void complete() {
        this.end();
        for (Map.Entry<CurrencyHook, Double> entry : this.player1.getCurrencies().entrySet()) {
            if (!(entry.getKey().getBalance(this.player1.getPlayer().getUniqueId()) < entry.getValue())) continue;
            this.abort(true);
            return;
        }
        for (Map.Entry<CurrencyHook, Double> entry : this.player2.getCurrencies().entrySet()) {
            if (!(entry.getKey().getBalance(this.player2.getPlayer().getUniqueId()) < entry.getValue())) continue;
            this.abort(true);
            return;
        }
        AxTradeCompleteEvent event = new AxTradeCompleteEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            this.abort(true);
            return;
        }
        CurrencyProcessor currencyProcessor1 = new CurrencyProcessor(this.player1.getPlayer(), this.player1.getCurrencies().entrySet());
        currencyProcessor1.run().thenAccept(success1 -> {
            if (!success1.booleanValue()) {
                this.abort(true);
                return;
            }
            CurrencyProcessor currencyProcessor2 = new CurrencyProcessor(this.player2.getPlayer(), this.player2.getCurrencies().entrySet());
            currencyProcessor2.run().thenAccept(success2 -> {
                if (!success2.booleanValue()) {
                    this.abort(true);
                    currencyProcessor1.reverse();
                    return;
                }
                AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player1.getPlayer(), "trade.completed", Map.of("%player%", this.player2.getPlayer().getName()));
                AxTrade.MESSAGEUTILS.sendLang((CommandSender)this.player2.getPlayer(), "trade.completed", Map.of("%player%", this.player1.getPlayer().getName()));
                SoundUtils.playSound(this.player1.getPlayer(), "completed");
                SoundUtils.playSound(this.player2.getPlayer(), "completed");
                ArrayList<CallSite> player1Currencies = new ArrayList<CallSite>();
                for (Map.Entry<CurrencyHook, Double> entry : this.player1.getCurrencies().entrySet()) {
                    double d = TaxUtils.getTotalAfterTax(entry.getValue(), entry.getKey());
                    entry.getKey().giveBalance(this.player2.getPlayer().getUniqueId(), d);
                    String currencyName = Utils.getFormattedCurrency(entry.getKey());
                    String fullCurrencyAmount = NumberUtils.formatNumber(entry.getValue());
                    String taxedCurrencyAmount = NumberUtils.formatNumber(d);
                    if (d == entry.getValue()) {
                        player1Currencies.add((CallSite)((Object)(currencyName + ": " + taxedCurrencyAmount)));
                    } else {
                        player1Currencies.add((CallSite)((Object)(currencyName + ": " + taxedCurrencyAmount + " (+ tax: " + NumberUtils.formatNumber(entry.getValue() - d) + ")")));
                    }
                    if (!AxTrade.CONFIG.getBoolean("enable-trade-summaries")) continue;
                    AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player2.getPlayer(), AxTrade.LANG.getString("summary.get.currency"), Map.of("%amount%", taxedCurrencyAmount, "%currency%", currencyName));
                    AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player1.getPlayer(), AxTrade.LANG.getString("summary.give.currency"), Map.of("%amount%", fullCurrencyAmount, "%currency%", currencyName));
                }
                ArrayList<CallSite> player2Currencies = new ArrayList<CallSite>();
                for (Map.Entry<CurrencyHook, Double> entry : this.player2.getCurrencies().entrySet()) {
                    double amountAfterTax = TaxUtils.getTotalAfterTax(entry.getValue(), entry.getKey());
                    entry.getKey().giveBalance(this.player1.getPlayer().getUniqueId(), amountAfterTax);
                    String currencyName = Utils.getFormattedCurrency(entry.getKey());
                    String fullCurrencyAmount = NumberUtils.formatNumber(entry.getValue());
                    String taxedCurrencyAmount = NumberUtils.formatNumber(amountAfterTax);
                    if (amountAfterTax == entry.getValue()) {
                        player2Currencies.add((CallSite)((Object)(currencyName + ": " + taxedCurrencyAmount)));
                    } else {
                        player2Currencies.add((CallSite)((Object)(currencyName + ": " + taxedCurrencyAmount + " (+ tax: " + NumberUtils.formatNumber(entry.getValue() - amountAfterTax) + ")")));
                    }
                    if (!AxTrade.CONFIG.getBoolean("enable-trade-summaries")) continue;
                    AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player2.getPlayer(), AxTrade.LANG.getString("summary.give.currency"), Map.of("%amount%", fullCurrencyAmount, "%currency%", currencyName));
                    AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player1.getPlayer(), AxTrade.LANG.getString("summary.get.currency"), Map.of("%amount%", taxedCurrencyAmount, "%currency%", currencyName));
                }
                ArrayList arrayList = new ArrayList();
                this.player1.getTradeGui().getItems(false).forEach(itemStack -> {
                    if (itemStack == null) {
                        return;
                    }
                    Scheduler.get().runAt(this.player2.getPlayer().getLocation(), task -> ContainerUtils.INSTANCE.addOrDrop((Inventory)this.player2.getPlayer().getInventory(), List.of(itemStack), this.player2.getPlayer().getLocation()));
                    String itemName = Utils.getFormattedItemName(itemStack);
                    int itemAm = itemStack.getAmount();
                    player1Items.add(itemAm + "x " + itemName);
                    if (AxTrade.CONFIG.getBoolean("enable-trade-summaries")) {
                        AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player1.getPlayer(), AxTrade.LANG.getString("summary.give.item"), Map.of("%amount%", "" + itemAm, "%item%", itemName));
                        AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player2.getPlayer(), AxTrade.LANG.getString("summary.get.item"), Map.of("%amount%", "" + itemAm, "%item%", itemName));
                    }
                });
                ArrayList arrayList2 = new ArrayList();
                this.player2.getTradeGui().getItems(false).forEach(itemStack -> {
                    if (itemStack == null) {
                        return;
                    }
                    Scheduler.get().runAt(this.player1.getPlayer().getLocation(), task -> ContainerUtils.INSTANCE.addOrDrop((Inventory)this.player1.getPlayer().getInventory(), List.of(itemStack), this.player1.getPlayer().getLocation()));
                    String itemName = Utils.getFormattedItemName(itemStack);
                    int itemAm = itemStack.getAmount();
                    player2Items.add(itemAm + "x " + itemName);
                    if (AxTrade.CONFIG.getBoolean("enable-trade-summaries")) {
                        AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player2.getPlayer(), AxTrade.LANG.getString("summary.give.item"), Map.of("%amount%", "" + itemAm, "%item%", itemName));
                        AxTrade.MESSAGEUTILS.sendFormatted((CommandSender)this.player1.getPlayer(), AxTrade.LANG.getString("summary.get.item"), Map.of("%amount%", "" + itemAm, "%item%", itemName));
                    }
                });
                HistoryUtils.writeToHistory(String.format("%s: [Currencies: %s] [Items: %s] | %s: [Currencies: %s] [Items: %s]", this.player1.getPlayer().getName(), player1Currencies.isEmpty() ? "---" : String.join((CharSequence)", ", player1Currencies), arrayList.isEmpty() ? "---" : String.join((CharSequence)", ", arrayList), this.player2.getPlayer().getName(), player2Currencies.isEmpty() ? "---" : String.join((CharSequence)", ", player2Currencies), arrayList2.isEmpty() ? "---" : String.join((CharSequence)", ", arrayList2)));
            });
        });
    }

    public long getPrepTime() {
        return this.prepTime;
    }

    public TradePlayer getPlayer1() {
        return this.player1;
    }

    public TradePlayer getPlayer2() {
        return this.player2;
    }

    public Player getOtherPlayer(Player player) {
        return this.player1.getPlayer().equals((Object)player) ? this.player2.getPlayer() : this.player1.getPlayer();
    }

    public boolean isEnded() {
        return this.ended;
    }
}

