/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.request;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.api.events.AxTradeRequestEvent;
import com.artillexstudios.axtrade.libs.axapi.nms.wrapper.ServerPlayerWrapper;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import com.artillexstudios.axtrade.request.Request;
import com.artillexstudios.axtrade.safety.SafetyManager;
import com.artillexstudios.axtrade.trade.Trades;
import com.artillexstudios.axtrade.utils.SoundUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Requests {
    private static final ArrayList<Request> requests = new ArrayList();

    public static void addRequest(@NotNull Player sender, @NotNull Player receiver) {
        if (!SafetyManager.TRADING.get()) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "safety", new TagResolver[0]);
            return;
        }
        Map<String, String> replacements = Map.of("%player%", receiver.getName());
        boolean disallowSameIp = AxTrade.CONFIG.getBoolean("disallow-same-ip-trade", false);
        if (disallowSameIp && sender.getAddress() != null && receiver.getAddress() != null && sender.getAddress().getAddress().equals(receiver.getAddress().getAddress())) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.same-ip", replacements);
            return;
        }
        List<String> disallowed = AxTrade.CONFIG.getStringList("disallowed-gamemodes");
        if (disallowed.contains(sender.getGameMode().name()) || disallowed.contains(receiver.getGameMode().name())) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.disallowed-gamemode", replacements);
            return;
        }
        List<String> blacklisted = AxTrade.CONFIG.getStringList("blacklisted-worlds");
        if (blacklisted.contains(sender.getWorld().getName()) || blacklisted.contains(receiver.getWorld().getName())) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.blacklisted-world", replacements);
            return;
        }
        if (sender.isDead() || receiver.isDead()) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.not-accepting", replacements);
            return;
        }
        if (AxTrade.TOGGLED.getBoolean("toggled." + String.valueOf(receiver.getUniqueId()))) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.not-accepting", replacements);
            return;
        }
        if (AxTrade.TOGGLED.getBoolean("toggled." + String.valueOf(sender.getUniqueId()))) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.disabled-trading", replacements);
            return;
        }
        if (sender.equals((Object)receiver)) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.cant-trade-self", replacements);
            return;
        }
        if (Trades.isTrading(receiver) || Trades.isTrading(sender)) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.already-in-trade", replacements);
            return;
        }
        int maxDist = AxTrade.CONFIG.getInt("trade-max-distance", 10);
        if (maxDist != -1 && (sender.getWorld() != receiver.getWorld() || (double)maxDist < sender.getLocation().distance(receiver.getLocation()))) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.too-far", replacements);
            return;
        }
        Request request = Requests.getRequest(sender, receiver);
        if (request != null) {
            if (!request.getSender().equals((Object)sender)) {
                Trades.addTrade(sender, receiver);
                requests.remove(request);
                request.deactivate();
                return;
            }
            if (!request.isActive() || System.currentTimeMillis() - request.getTime() < (long)AxTrade.CONFIG.getInt("trade-request-expire-seconds", 60) * 1000L) {
                AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.already-sent", replacements);
                return;
            }
        }
        AxTradeRequestEvent apiEvent = new AxTradeRequestEvent(sender, receiver);
        Bukkit.getPluginManager().callEvent((Event)apiEvent);
        if (apiEvent.isCancelled()) {
            return;
        }
        requests.add(new Request(sender, receiver));
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.sent-sender", replacements);
        Map<String, String> replacements2 = Map.of("%player%", sender.getName());
        if (AxTrade.LANG.getSection("request.sent-receiver") == null) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)receiver, "request.sent-receiver", replacements2);
        } else {
            ServerPlayerWrapper receiverWrap = ServerPlayerWrapper.wrap(receiver);
            receiverWrap.message(StringUtils.format(AxTrade.CONFIG.getString("prefix") + AxTrade.LANG.getString("request.sent-receiver.info"), replacements2));
            receiverWrap.message(StringUtils.format(AxTrade.LANG.getString("request.sent-receiver.accept.message"), replacements2).hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)StringUtils.format(AxTrade.LANG.getString("request.sent-receiver.accept.hover"), replacements2))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/trade accept " + sender.getName()))));
            receiverWrap.message(StringUtils.format(AxTrade.LANG.getString("request.sent-receiver.deny.message"), replacements2).hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)StringUtils.format(AxTrade.LANG.getString("request.sent-receiver.deny.hover"), replacements2))).clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/trade deny " + sender.getName()))));
        }
        SoundUtils.playSound(sender, "requested");
        SoundUtils.playSound(receiver, "requested");
    }

    public static boolean hasRequest(Player p1, Player p2) {
        for (Request rq : requests) {
            if (rq.getSender() != p1 && rq.getSender() != p2 || rq.getReceiver() != p1 && rq.getReceiver() != p2) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Request getRequest(Player p1, Player p2) {
        for (Request rq : requests) {
            if (rq.getSender() != p1 && rq.getSender() != p2 || rq.getReceiver() != p1 && rq.getReceiver() != p2) continue;
            return rq;
        }
        return null;
    }

    public static ArrayList<Request> getRequests() {
        return requests;
    }
}

