/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.listeners;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.request.Request;
import com.artillexstudios.axtrade.request.Requests;
import com.artillexstudios.axtrade.trade.Trade;
import com.artillexstudios.axtrade.trade.Trades;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public class TradeListeners
implements Listener {
    @EventHandler
    public void onQuit(@NotNull PlayerQuitEvent event) {
        this.handleQuitTrade(event);
        this.handleQuitRequest(event);
    }

    public void handleQuitTrade(@NotNull PlayerQuitEvent event) {
        Player player = event.getPlayer();
        Trade trade = Trades.getTrade(player);
        if (trade == null) {
            return;
        }
        trade.abort();
    }

    public void handleQuitRequest(@NotNull PlayerQuitEvent event) {
        Iterator<Request> iterator = Requests.getRequests().iterator();
        while (iterator.hasNext()) {
            Request request = iterator.next();
            if (request.getSender().equals((Object)event.getPlayer())) {
                iterator.remove();
                continue;
            }
            if (!request.getReceiver().equals((Object)event.getPlayer())) continue;
            iterator.remove();
            if (!request.isActive()) continue;
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)request.getSender(), "request.expired", Map.of("%player%", request.getReceiver().getName()));
        }
    }

    @EventHandler
    public void onDrop(@NotNull PlayerDropItemEvent event) {
        this.cancelIfTrading(event.getPlayer(), (Cancellable)event);
    }

    @EventHandler
    public void onPickup(@NotNull EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        this.cancelIfTrading(player, (Cancellable)event);
    }

    @EventHandler
    public void onMove(@NotNull PlayerMoveEvent event) {
        if (event.getTo() == null) {
            return;
        }
        Trade trade = Trades.getTrade(event.getPlayer());
        if (trade == null) {
            return;
        }
        if (!AxTrade.CONFIG.getBoolean("abort.move", true)) {
            return;
        }
        if (System.currentTimeMillis() - trade.getPrepTime() < 1000L) {
            return;
        }
        if (event.getFrom().distanceSquared(event.getTo()) == 0.0) {
            return;
        }
        trade.abort();
    }

    @EventHandler
    public void onInteract(@NotNull PlayerInteractEvent event) {
        Trade trade = Trades.getTrade(event.getPlayer());
        if (trade == null) {
            return;
        }
        if (!AxTrade.CONFIG.getBoolean("abort.interact", true)) {
            return;
        }
        if (System.currentTimeMillis() - trade.getPrepTime() < 1000L) {
            return;
        }
        event.setCancelled(true);
        trade.abort();
    }

    @EventHandler
    public void onCommand(@NotNull PlayerCommandPreprocessEvent event) {
        Trade trade = Trades.getTrade(event.getPlayer());
        if (trade == null) {
            return;
        }
        if (!AxTrade.CONFIG.getBoolean("abort.command", true)) {
            return;
        }
        event.setCancelled(true);
        trade.abort();
    }

    private void cancelIfTrading(Player player, Cancellable event) {
        Trade trade = Trades.getTrade(player);
        if (trade == null) {
            return;
        }
        event.setCancelled(true);
    }
}

