/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.listeners;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.libs.axapi.utils.Cooldown;
import com.artillexstudios.axtrade.request.Requests;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.jetbrains.annotations.NotNull;

public class EntityInteractListener
implements Listener {
    private static final Cooldown<Player> cooldown = Cooldown.create();

    @EventHandler(ignoreCancelled=true)
    public void onInteract(@NotNull PlayerInteractEntityEvent event) {
        if (!AxTrade.CONFIG.getBoolean("shift-click-send-request", true)) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("axtrade.trade")) {
            return;
        }
        if (cooldown.hasCooldown(player)) {
            return;
        }
        if (!player.isSneaking()) {
            return;
        }
        Entity entity = event.getRightClicked();
        if (!(entity instanceof Player)) {
            return;
        }
        Player sendTo = (Player)entity;
        if (!sendTo.isOnline()) {
            return;
        }
        cooldown.addCooldown(player, 100L);
        Requests.addRequest(player, sendTo);
        event.setCancelled(true);
    }
}

