/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axtrade.commands;

import com.artillexstudios.axtrade.AxTrade;
import com.artillexstudios.axtrade.hooks.HookManager;
import com.artillexstudios.axtrade.lang.LanguageManager;
import com.artillexstudios.axtrade.libs.axapi.utils.StringUtils;
import com.artillexstudios.axtrade.libs.lamp.annotation.DefaultFor;
import com.artillexstudios.axtrade.libs.lamp.annotation.Optional;
import com.artillexstudios.axtrade.libs.lamp.annotation.Subcommand;
import com.artillexstudios.axtrade.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axtrade.libs.lamp.bukkit.annotation.CommandPermission;
import com.artillexstudios.axtrade.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axtrade.libs.lamp.orphan.Orphans;
import com.artillexstudios.axtrade.request.Request;
import com.artillexstudios.axtrade.request.Requests;
import com.artillexstudios.axtrade.trade.Trade;
import com.artillexstudios.axtrade.trade.Trades;
import com.artillexstudios.axtrade.utils.CommandMessages;
import com.artillexstudios.axtrade.utils.NumberUtils;
import com.artillexstudios.axtrade.utils.SoundUtils;
import java.util.Locale;
import java.util.Map;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@CommandPermission(value="axtrade.trade")
public class Commands
implements OrphanCommand {
    private static BukkitCommandHandler handler = null;

    public void help(@NotNull CommandSender sender) {
        if (sender.hasPermission("axtrade.admin")) {
            for (String m : AxTrade.LANG.getStringList("admin-help")) {
                sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
            }
        } else {
            for (String m : AxTrade.LANG.getStringList("player-help")) {
                sender.sendMessage(StringUtils.formatToString(m, new TagResolver[0]));
            }
        }
    }

    @DefaultFor(value={"~"})
    public void trade(@NotNull Player sender, @Optional Player other) {
        if (other == null) {
            this.help((CommandSender)sender);
            return;
        }
        Requests.addRequest(sender, other);
    }

    @Subcommand(value={"accept"})
    public void accept(@NotNull Player sender, @NotNull Player other) {
        Request request = Requests.getRequest(sender, other);
        if (request == null || request.getSender().equals((Object)sender) || !request.isActive()) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.no-request", Map.of("%player%", other.getName()));
            return;
        }
        Requests.addRequest(sender, other);
    }

    @Subcommand(value={"deny"})
    public void deny(@NotNull Player sender, @NotNull Player other) {
        Request request = Requests.getRequest(sender, other);
        if (request == null || request.getSender().equals((Object)sender) || !request.isActive()) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.no-request", Map.of("%player%", other.getName()));
            return;
        }
        request.deactivate();
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)request.getSender(), "request.deny-sender", Map.of("%player%", request.getReceiver().getName()));
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)request.getReceiver(), "request.deny-receiver", Map.of("%player%", request.getSender().getName()));
        SoundUtils.playSound(request.getSender(), "deny");
        SoundUtils.playSound(request.getReceiver(), "deny");
    }

    @CommandPermission(value="axtrade.toggle")
    @Subcommand(value={"toggle"})
    public void toggle(@NotNull Player sender) {
        boolean toggled = AxTrade.TOGGLED.getBoolean("toggled." + String.valueOf(sender.getUniqueId()), false);
        if (toggled) {
            AxTrade.TOGGLED.getBackingDocument().remove("toggled." + String.valueOf(sender.getUniqueId()));
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "toggle.enabled", new TagResolver[0]);
        } else {
            AxTrade.TOGGLED.set("toggled." + String.valueOf(sender.getUniqueId()), true);
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "toggle.disabled", new TagResolver[0]);
        }
        AxTrade.TOGGLED.save();
    }

    @Subcommand(value={"reload"})
    @CommandPermission(value="axtrade.admin")
    public void reload(@NotNull CommandSender sender) {
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD[AxTrade] &#AAFFDDReloading configuration...", new TagResolver[0]));
        if (!AxTrade.CONFIG.reload()) {
            AxTrade.MESSAGEUTILS.sendLang(sender, "reload.failed", Map.of("%file%", "config.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD\u2560 &#AAFFDDReloaded &fconfig.yml&#AAFFDD!", new TagResolver[0]));
        if (!AxTrade.LANG.reload()) {
            AxTrade.MESSAGEUTILS.sendLang(sender, "reload.failed", Map.of("%file%", "lang.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD\u2560 &#AAFFDDReloaded &flang.yml&#AAFFDD!", new TagResolver[0]));
        if (!AxTrade.GUIS.reload()) {
            AxTrade.MESSAGEUTILS.sendLang(sender, "reload.failed", Map.of("%file%", "guis.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD\u2560 &#AAFFDDReloaded &fguis.yml&#AAFFDD!", new TagResolver[0]));
        if (!AxTrade.HOOKS.reload()) {
            AxTrade.MESSAGEUTILS.sendLang(sender, "reload.failed", Map.of("%file%", "currencies.yml"));
            return;
        }
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD\u2560 &#AAFFDDReloaded &fcurrencies.yml&#AAFFDD!", new TagResolver[0]));
        LanguageManager.reload();
        HookManager.updateHooks();
        NumberUtils.reload();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#00FFDD\u255a &#AAFFDDSuccessful reload!", new TagResolver[0]));
        AxTrade.MESSAGEUTILS.sendLang(sender, "reload.success", new TagResolver[0]);
    }

    @Subcommand(value={"force"})
    @CommandPermission(value="axtrade.admin")
    public void force(@NotNull Player sender, Player other) {
        if (sender.equals((Object)other)) {
            AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "request.cant-trade-self", new TagResolver[0]);
            return;
        }
        Trades.addTrade(sender, other);
    }

    @Subcommand(value={"preview"})
    @CommandPermission(value="axtrade.admin")
    public void preview(@NotNull Player sender) {
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxTrade] Opening trade preview for " + sender.getName() + ", any errors under this should be ignored!", new TagResolver[0]));
        new Trade(sender, sender);
        AxTrade.MESSAGEUTILS.sendLang((CommandSender)sender, "trade.preview-info", new TagResolver[0]);
    }

    public static void registerCommand() {
        if (handler == null) {
            handler = BukkitCommandHandler.create((Plugin)AxTrade.getInstance());
            handler.getTranslator().add(new CommandMessages());
            handler.setLocale(Locale.of("en", "US"));
        }
        handler.unregisterAllCommands();
        handler.register(Orphans.path((String[])AxTrade.CONFIG.getStringList("command-aliases").toArray(String[]::new)).handler(new Commands()));
        handler.registerBrigadier();
    }
}

