/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.listeners.impl;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.cache.Shulkerboxes;
import com.artillexstudios.axshulkers.safety.SafetyManager;
import com.artillexstudios.axshulkers.utils.MessageUtils;
import com.artillexstudios.axshulkers.utils.ShulkerUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ShulkerOpenListener
implements Listener {
    private final HashMap<UUID, Long> cds = new HashMap();

    @EventHandler
    public void onInteract(@NotNull PlayerInteractEvent event) {
        if (event.getAction() == Action.PHYSICAL) {
            return;
        }
        Player player = event.getPlayer();
        if (ShulkerUtils.getOpenShulker(player) != null && event.getAction() != Action.LEFT_CLICK_AIR) {
            player.closeInventory();
        }
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!SafetyManager.CLICK_OPENING.get()) {
            MessageUtils.sendMsgP((CommandSender)event.getPlayer(), "safety");
            return;
        }
        boolean opened = this.openShulker(player, event.getItem());
        if (opened) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onShulkerClick(@NotNull InventoryClickEvent event) {
        if (!event.getClick().equals((Object)ClickType.RIGHT)) {
            return;
        }
        if (!AxShulkers.CONFIG.getBoolean("opening-from-inventory.enabled").booleanValue()) {
            return;
        }
        if (!ShulkerUtils.isAllowedInventoryType(event.getView().getTopInventory())) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getClickedInventory() != null && !event.getClickedInventory().equals((Object)event.getWhoClicked().getInventory())) {
            if (!event.getClickedInventory().equals((Object)event.getWhoClicked().getEnderChest())) {
                return;
            }
            if (!AxShulkers.CONFIG.getBoolean("opening-from-inventory.open-from-enderchest").booleanValue()) {
                return;
            }
        }
        if (event.getView().getTopInventory().getType().equals((Object)InventoryType.SHULKER_BOX)) {
            for (Shulkerbox shulkerbox : Shulkerboxes.getShulkerMap().values()) {
                if (!shulkerbox.getShulkerInventory().equals((Object)event.getView().getTopInventory()) || !shulkerbox.getUUID().equals(ShulkerUtils.getShulkerUUID(event.getCurrentItem()))) continue;
                event.setCancelled(true);
                AxShulkers.getScheduler().runNextTick(t -> event.getWhoClicked().closeInventory());
                return;
            }
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (!SafetyManager.INVENTORY_OPENING.get()) {
            MessageUtils.sendMsgP((CommandSender)event.getWhoClicked(), "safety");
            return;
        }
        boolean opened = this.openShulker(player, event.getCurrentItem());
        if (opened) {
            event.setCancelled(true);
        }
    }

    private boolean openShulker(@NotNull Player player, ItemStack it) {
        if (!player.hasPermission("axshulkers.use")) {
            return false;
        }
        if (!ShulkerUtils.isShulker(it)) {
            return false;
        }
        if (it.getAmount() > 1) {
            it.setAmount(1);
            return false;
        }
        if (AxShulkers.CONFIG.getBoolean("disable-shulker-opening").booleanValue()) {
            return false;
        }
        if (AxShulkers.CONFIG.getStringList("blacklisted-worlds").contains(player.getWorld().getName())) {
            MessageUtils.sendMsgP((CommandSender)player, "errors.blacklisted-world");
            return false;
        }
        long openCooldown = AxShulkers.CONFIG.getLong("open-cooldown-milliseconds");
        if (this.cds.containsKey(player.getUniqueId()) && System.currentTimeMillis() - this.cds.get(player.getUniqueId()) < openCooldown) {
            MessageUtils.sendMsgP((CommandSender)player, "cooldown", Map.of("%seconds%", "" + ((openCooldown - System.currentTimeMillis() + this.cds.get(player.getUniqueId())) / 1000L + 1L)));
            return false;
        }
        this.cds.put(player.getUniqueId(), System.currentTimeMillis());
        String name = ShulkerUtils.getShulkerName(it);
        if (Shulkerboxes.getShulker(it, name) == null) {
            return false;
        }
        AxShulkers.getScheduler().runAtLocation(player.getLocation(), t -> {
            Shulkerbox shulkerbox = Shulkerboxes.getShulker(it, name);
            if (shulkerbox == null) {
                return;
            }
            if (player.getOpenInventory().getTopInventory().getType().equals((Object)InventoryType.SHULKER_BOX)) {
                shulkerbox.close();
            }
            ShulkerUtils.clearShulkerContents(it);
            shulkerbox.setItem(it);
            shulkerbox.updateReference();
            shulkerbox.openShulkerFor(player);
            MessageUtils.sendMsgP((CommandSender)player, "open.message", Collections.singletonMap("%name%", shulkerbox.getTitle()));
            if (!AxShulkers.MESSAGES.getString("open.sound", "").isBlank()) {
                player.playSound(player.getLocation(), Sound.valueOf((String)AxShulkers.MESSAGES.getString("open.sound")), 1.0f, 1.0f);
            }
        });
        return true;
    }
}

