/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.utils;

import com.artillexstudios.axshulkers.libs.kyori.adventure.text.Component;
import com.artillexstudios.axshulkers.libs.kyori.adventure.text.format.TextDecoration;
import com.artillexstudios.axshulkers.libs.kyori.adventure.text.minimessage.MiniMessage;
import com.artillexstudios.axshulkers.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class ColorUtils {
    private static LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER = null;
    private static LegacyComponentSerializer LEGACY_FORMATTER = null;
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();

    @NotNull
    public static String format(@NotNull String message) {
        message = message.replace('\u00a7', '&');
        message = ColorUtils.toLegacy(MINI_MESSAGE.deserialize(message).applyFallbackStyle(TextDecoration.ITALIC.withState(false)));
        message = LEGACY_FORMATTER.serialize(LEGACY_FORMATTER.deserialize(message));
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    @NotNull
    public static Component formatToComponent(@NotNull String message) {
        return ColorUtils.toComponent(ColorUtils.format(message));
    }

    @NotNull
    public static String toLegacy(@NotNull Component component) {
        return LEGACY_COMPONENT_SERIALIZER.serialize(component);
    }

    @NotNull
    public static Component toComponent(@NotNull String message) {
        return LEGACY_COMPONENT_SERIALIZER.deserialize(message);
    }

    static {
        String packageName = Bukkit.getServer().getClass().getPackage().getName();
        String v = packageName.substring(packageName.lastIndexOf(46) + 1);
        if (v.contains("1_13") || v.contains("1_14") || v.contains("1_15")) {
            LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').useUnusualXRepeatedCharacterHexFormat().build();
            LEGACY_FORMATTER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).useUnusualXRepeatedCharacterHexFormat().build();
        } else {
            LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').useUnusualXRepeatedCharacterHexFormat().hexColors().build();
            LEGACY_FORMATTER = ((LegacyComponentSerializer.Builder)LegacyComponentSerializer.legacyAmpersand().toBuilder()).useUnusualXRepeatedCharacterHexFormat().hexColors().build();
        }
    }
}

