/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.listeners.impl;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.cache.Shulkerboxes;
import com.artillexstudios.axshulkers.utils.BlacklistUtils;
import com.artillexstudios.axshulkers.utils.MessageUtils;
import com.artillexstudios.axshulkers.utils.ShulkerUtils;
import java.util.Collections;
import org.bukkit.GameMode;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryClickListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onClick(@NotNull InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (player.getOpenInventory().getTopInventory().getType() != InventoryType.SHULKER_BOX) {
            return;
        }
        ItemStack it = this.getItem(event);
        if (!player.hasPermission("axshulkers.modify")) {
            event.setCancelled(true);
            return;
        }
        if (BlacklistUtils.isBlacklisted(it)) {
            event.setCancelled(true);
            MessageUtils.sendMsgP((CommandSender)player, "errors.banned-item");
            return;
        }
        if (ShulkerUtils.isShulker(it)) {
            event.setCancelled(true);
        }
        if (ShulkerUtils.isShulker(event.getCurrentItem())) {
            event.setCancelled(true);
        }
    }

    @Nullable
    private ItemStack getItem(InventoryClickEvent event) {
        if (event.getClick() == ClickType.NUMBER_KEY && event.getClickedInventory() != null) {
            Inventory inventory = event.getClickedInventory().getType() == InventoryType.PLAYER && event.getAction() != InventoryAction.HOTBAR_SWAP ? event.getView().getTopInventory() : event.getView().getBottomInventory();
            return inventory.getItem(event.getHotbarButton());
        }
        return event.getCurrentItem();
    }

    @EventHandler
    public void onDrag(@NotNull InventoryDragEvent event) {
        Shulkerbox shulker = ShulkerUtils.getOpenShulker((Player)event.getWhoClicked());
        if (shulker == null) {
            return;
        }
        if (!event.getWhoClicked().hasPermission("axshulkers.modify")) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onClose(@NotNull InventoryCloseEvent event) {
        Shulkerbox shulker = ShulkerUtils.getOpenShulker((Player)event.getPlayer());
        if (shulker == null) {
            return;
        }
        MessageUtils.sendMsgP((CommandSender)event.getPlayer(), "close.message", Collections.singletonMap("%name%", shulker.getTitle()));
        if (!AxShulkers.MESSAGES.getString("close.sound", "").isBlank()) {
            ((Player)event.getPlayer()).playSound(event.getPlayer().getLocation(), Sound.valueOf((String)AxShulkers.MESSAGES.getString("close.sound")), 1.0f, 1.0f);
        }
        ShulkerUtils.setShulkerContents(shulker.getItem(), event.getPlayer().getOpenInventory().getTopInventory(), false);
        if (AxShulkers.CONFIG.getBoolean("enable-obfuscation", (Boolean)false).booleanValue() || !AxShulkers.CONFIG.getBoolean("auto-clear-shulkers", (Boolean)false).booleanValue() && (!AxShulkers.CONFIG.getBoolean("auto-clear-in-creative", (Boolean)true).booleanValue() || !event.getPlayer().getGameMode().equals((Object)GameMode.CREATIVE))) {
            return;
        }
        if (!((ItemStack)shulker.getReference().get()).equals((Object)shulker.getItem())) {
            return;
        }
        ShulkerUtils.removeShulkerUUID(shulker.getItem());
        Shulkerboxes.removeShulkerbox(shulker.getUUID());
        AxShulkers.getDatabaseQueue().submit(() -> AxShulkers.getDB().removeShulker(shulker.getUUID()));
    }
}

