/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.listeners.impl;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.cache.Shulkerboxes;
import com.artillexstudios.axshulkers.safety.SafetyManager;
import com.artillexstudios.axshulkers.utils.ShulkerUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BlockDispenseListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onDispense(@NotNull BlockDispenseEvent event) {
        if (!ShulkerUtils.isShulker(event.getItem())) {
            return;
        }
        if (!SafetyManager.DISPENSE.get()) {
            event.setCancelled(true);
            return;
        }
        if (AxShulkers.CONFIG.getBoolean("disable-shulker-dispensing").booleanValue()) {
            event.setCancelled(true);
            return;
        }
        if (event.getItem().getAmount() != 1) {
            event.getItem().setAmount(1);
            event.setCancelled(true);
            return;
        }
        if (event.getBlock().getType().equals((Object)Material.DROPPER)) {
            this.handleDropper(event);
        } else {
            this.handleDispenser(event);
        }
    }

    public void handleDropper(@NotNull BlockDispenseEvent event) {
        String name;
        ItemStack it = event.getItem();
        Shulkerbox shulkerbox = Shulkerboxes.getShulker(it, name = ShulkerUtils.getShulkerName(it));
        if (shulkerbox == null) {
            return;
        }
        ShulkerUtils.setShulkerContents(event.getItem(), shulkerbox.getShulkerInventory(), false);
    }

    public void handleDispenser(@NotNull BlockDispenseEvent event) {
        if (ShulkerUtils.getShulkerUUID(event.getItem()) == null) {
            return;
        }
        Directional directional = (Directional)event.getBlock().getBlockData();
        Block facingBlock = event.getBlock().getRelative(directional.getFacing());
        if (!facingBlock.getType().equals((Object)Material.AIR)) {
            return;
        }
        Dispenser dispenser = (Dispenser)event.getBlock().getState();
        event.setCancelled(true);
        for (ItemStack it : dispenser.getInventory()) {
            String name;
            Shulkerbox shulkerbox;
            if (!ShulkerUtils.isShulker(it) || (shulkerbox = Shulkerboxes.getShulker(it, name = ShulkerUtils.getShulkerName(it))) == null) continue;
            shulkerbox.close();
            ShulkerUtils.setShulkerContents(it, shulkerbox.getShulkerInventory(), true);
            ShulkerUtils.removeShulkerUUID(it);
            AxShulkers.getDatabaseQueue().submit(() -> {
                AxShulkers.getDB().removeShulker(shulkerbox.getUUID());
                Shulkerboxes.removeShulkerbox(shulkerbox.getUUID());
            });
        }
        dispenser.dispense();
    }
}

