/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.utils;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.cache.Shulkerboxes;
import com.artillexstudios.axshulkers.libs.nbtapi.NBT;
import com.artillexstudios.axshulkers.utils.ColorUtils;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.ShulkerBox;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerUtils {
    private static final Set<Material> shulkers = EnumSet.of(Material.SHULKER_BOX, new Material[]{Material.WHITE_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.PINK_SHULKER_BOX});
    private static final Set<InventoryType> inventories = new HashSet<InventoryType>();

    private static void addType(String str) {
        try {
            inventories.add(InventoryType.valueOf((String)str));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isShulker(@Nullable ItemStack it) {
        if (it == null) {
            return false;
        }
        return shulkers.contains(it.getType());
    }

    public static boolean isAllowedInventoryType(@NotNull Inventory inventory) {
        return inventories.contains(inventory.getType());
    }

    @NotNull
    public static ItemStack[] getShulkerItems(@NotNull ItemStack it) {
        BlockStateMeta im = (BlockStateMeta)it.getItemMeta();
        ShulkerBox shulker = (ShulkerBox)im.getBlockState();
        Inventory inv = shulker.getInventory();
        return inv.getContents();
    }

    @Nullable
    public static UUID getShulkerUUID(@Nullable ItemStack it) {
        if (it == null) {
            return null;
        }
        if (it.getType().equals((Object)Material.AIR)) {
            return null;
        }
        String str = NBT.get(it, nbti -> nbti.getString(AxShulkers.CONFIG.getString("nbt-tag")));
        if (str.isEmpty()) {
            return null;
        }
        return UUID.fromString(str);
    }

    public static void removeShulkerUUID(@NotNull ItemStack it) {
        NBT.modify(it, nbt -> nbt.removeKey(AxShulkers.CONFIG.getString("nbt-tag")));
    }

    @NotNull
    public static UUID addShulkerUUID(@NotNull ItemStack it) {
        UUID uuid = UUID.randomUUID();
        NBT.modify(it, nbt -> nbt.setString(AxShulkers.CONFIG.getString("nbt-tag"), uuid.toString()));
        return uuid;
    }

    public static void setShulkerContents(@NotNull ItemStack it, @NotNull Inventory inventory, boolean bypass) {
        ItemMeta itemMeta = it.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta im = (BlockStateMeta)itemMeta;
        BlockState blockState = im.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        if (!bypass && AxShulkers.CONFIG.getBoolean("enable-obfuscation", (Boolean)false).booleanValue() && !AxShulkers.CONFIG.getBoolean("auto-clear-shulkers", (Boolean)false).booleanValue()) {
            shulker.getInventory().clear();
        } else {
            shulker.getInventory().setContents(inventory.getContents());
        }
        im.setBlockState((BlockState)shulker);
        it.setItemMeta((ItemMeta)im);
    }

    public static void clearShulkerContents(@NotNull ItemStack it) {
        ItemMeta itemMeta = it.getItemMeta();
        if (!(itemMeta instanceof BlockStateMeta)) {
            return;
        }
        BlockStateMeta im = (BlockStateMeta)itemMeta;
        BlockState blockState = im.getBlockState();
        if (!(blockState instanceof ShulkerBox)) {
            return;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        shulker.getInventory().clear();
        im.setBlockState((BlockState)shulker);
        it.setItemMeta((ItemMeta)im);
    }

    public static void setShulkerContents(@NotNull Block block, @NotNull Inventory inventory) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof ShulkerBox)) {
            return;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        shulker.getInventory().setContents(inventory.getContents());
        block.setBlockData(shulker.getBlockData());
    }

    public static void clearShulkerContents(@NotNull Block block) {
        BlockState blockState = block.getState();
        if (!(blockState instanceof ShulkerBox)) {
            return;
        }
        ShulkerBox shulker = (ShulkerBox)blockState;
        shulker.getInventory().clear();
        block.setBlockData(shulker.getBlockData());
    }

    public static String getShulkerName(@NotNull ItemStack it) {
        ItemMeta meta = it.getItemMeta();
        if (meta == null || meta.getDisplayName().isEmpty()) {
            return ColorUtils.format(AxShulkers.MESSAGES.getString("shulker-title"));
        }
        return meta.getDisplayName();
    }

    @Nullable
    public static Shulkerbox getOpenShulker(@NotNull Player player) {
        for (Shulkerbox shulkerbox : Shulkerboxes.getShulkerMap().values()) {
            if (!shulkerbox.getShulkerInventory().equals((Object)player.getOpenInventory().getTopInventory())) continue;
            return shulkerbox;
        }
        return null;
    }

    static {
        ShulkerUtils.addType("BARREL");
        inventories.add(InventoryType.CRAFTING);
        inventories.add(InventoryType.CREATIVE);
        inventories.add(InventoryType.CHEST);
        inventories.add(InventoryType.DISPENSER);
        inventories.add(InventoryType.DROPPER);
        inventories.add(InventoryType.ENDER_CHEST);
        inventories.add(InventoryType.HOPPER);
        inventories.add(InventoryType.PLAYER);
        inventories.add(InventoryType.SHULKER_BOX);
    }
}

