/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.safety;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.safety.Notifier;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.plugin.java.JavaPlugin;

public enum SafetyManager {
    INVENTORY_OPENING,
    CLICK_OPENING,
    PLACING,
    DISPENSE;

    private static final HttpClient client;
    private static final JavaPlugin instance;
    private static final Gson gson;
    private static ScheduledExecutorService service;
    private static Notifier notifier;
    private static boolean safe;
    private boolean enabled = true;

    public void set(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean get() {
        return this.enabled;
    }

    public static boolean isSafe() {
        return safe;
    }

    private static void check() {
        String body;
        String str = "https://api.artillex-studios.com/safety/?plugin=%s&version=%s&mc=%s".formatted(instance.getName(), instance.getDescription().getVersion(), Bukkit.getBukkitVersion());
        try {
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(str)).GET().build();
            body = client.send(request, HttpResponse.BodyHandlers.ofString()).body();
        }
        catch (Exception ignored) {
            return;
        }
        JsonArray disabled = (JsonArray)gson.fromJson(body, JsonArray.class);
        for (SafetyManager value : SafetyManager.values()) {
            value.set(true);
        }
        safe = true;
        for (JsonElement jsonElement : disabled) {
            try {
                SafetyManager.valueOf(jsonElement.getAsString()).set(false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            safe = false;
        }
        if (!safe) {
            notifier.sendAlert();
        }
    }

    public static void start() {
        if (!AxShulkers.CONFIG.getBoolean("enable-safety", (Boolean)true).booleanValue()) {
            return;
        }
        if (service != null) {
            return;
        }
        notifier = new Notifier();
        service = Executors.newSingleThreadScheduledExecutor();
        service.scheduleAtFixedRate(SafetyManager::check, 0L, 3L, TimeUnit.MINUTES);
    }

    public static void stop() {
        if (service == null) {
            return;
        }
        service.shutdownNow();
    }

    static {
        client = HttpClient.newHttpClient();
        instance = AxShulkers.getInstance();
        gson = new GsonBuilder().create();
        service = null;
        notifier = null;
        safe = true;
    }
}

