/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.database;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class DatabaseQueue
implements Runnable {
    private final Queue<Runnable> handlingQueue = Queues.newArrayDeque();
    private final Thread thread;
    private final Lock lock = new ReentrantLock();
    private final Condition cond = this.lock.newCondition();
    private volatile boolean kill = false;

    public DatabaseQueue(@NotNull String name) {
        this.thread = new Thread((Runnable)this, name);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        this.kill = true;
        Lock lock = this.lock;
        synchronized (lock) {
            this.cond.signalAll();
        }
    }

    public void submit(@NotNull Runnable runnable) {
        this.lock.lock();
        try {
            this.handlingQueue.offer(runnable);
            this.cond.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        while (!this.kill) {
            try {
                Runnable next = this.getNext();
                if (next == null) continue;
                next.run();
            }
            catch (InterruptedException exception) {
                exception.printStackTrace();
            }
        }
    }

    public Runnable getNext() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.handlingQueue.isEmpty() && !this.kill) {
                this.cond.await();
            }
            if (this.handlingQueue.isEmpty()) {
                Runnable runnable = null;
                return runnable;
            }
            Runnable runnable = this.handlingQueue.remove();
            return runnable;
        }
        finally {
            this.lock.unlock();
        }
    }
}

