/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.cache;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.utils.ShulkerUtils;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Shulkerboxes {
    private static final ConcurrentHashMap<UUID, Shulkerbox> shulkerboxMap = new ConcurrentHashMap();

    public static ConcurrentHashMap<UUID, Shulkerbox> getShulkerMap() {
        return shulkerboxMap;
    }

    public static void addShulkerbox(@NotNull Shulkerbox shulkerbox) {
        shulkerboxMap.put(shulkerbox.getUUID(), shulkerbox);
    }

    public static void removeShulkerbox(@NotNull UUID uuid) {
        shulkerboxMap.remove(uuid);
    }

    @Nullable
    public static Shulkerbox getShulker(@NotNull ItemStack it, @NotNull String name) {
        if (!ShulkerUtils.isShulker(it)) {
            return null;
        }
        UUID uuid = ShulkerUtils.getShulkerUUID(it);
        if (uuid == null) {
            ItemStack[] items = ShulkerUtils.getShulkerItems(it);
            UUID newUUID = ShulkerUtils.addShulkerUUID(it);
            AxShulkers.getDatabaseQueue().submit(() -> AxShulkers.getDB().saveShulker(items, newUUID));
            Inventory shulkerInv = Bukkit.createInventory(null, (InventoryType)InventoryType.SHULKER_BOX, (String)name);
            shulkerInv.setContents(items);
            Shulkerbox shulkerbox = new Shulkerbox(newUUID, shulkerInv, it, name);
            Shulkerboxes.addShulkerbox(shulkerbox);
            return shulkerbox;
        }
        if (!shulkerboxMap.containsKey(uuid)) {
            ItemStack[] shulkerItems = AxShulkers.getDB().getShulker(uuid);
            if (shulkerItems == null) {
                if (AxShulkers.CONFIG.getBoolean("delete-invalid-items", (Boolean)true).booleanValue()) {
                    ShulkerUtils.clearShulkerContents(it);
                }
                ShulkerUtils.removeShulkerUUID(it);
                return Shulkerboxes.getShulker(it, name);
            }
            Inventory shulkerInv = Bukkit.createInventory(null, (InventoryType)InventoryType.SHULKER_BOX, (String)name);
            shulkerInv.setContents(shulkerItems);
            Shulkerbox shulkerbox = new Shulkerbox(uuid, shulkerInv, it, name);
            Shulkerboxes.addShulkerbox(shulkerbox);
            return shulkerbox;
        }
        Shulkerbox shulkerbox = shulkerboxMap.get(uuid);
        shulkerbox.setItem(it);
        return shulkerbox;
    }
}

