/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers.cache;

import com.artillexstudios.axshulkers.AxShulkers;
import com.artillexstudios.axshulkers.utils.ColorUtils;
import com.artillexstudios.axshulkers.utils.ShulkerUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class Shulkerbox {
    private final UUID uuid;
    private Inventory shulkerInventory;
    private ItemStack it;
    private String title;
    private WeakReference<ItemStack> reference;

    public Shulkerbox(UUID uuid, Inventory shulkerInventory, ItemStack it, String title) {
        this.uuid = uuid;
        this.shulkerInventory = shulkerInventory;
        this.title = title;
        this.it = it;
        this.reference = new WeakReference<ItemStack>(it);
    }

    @NotNull
    public Inventory getShulkerInventory() {
        return this.shulkerInventory;
    }

    public void openShulkerFor(@NotNull Player player) {
        player.openInventory(this.shulkerInventory);
    }

    @NotNull
    public UUID getUUID() {
        return this.uuid;
    }

    @NotNull
    public ItemStack getItem() {
        return this.it;
    }

    @NotNull
    public WeakReference<ItemStack> getReference() {
        return this.reference;
    }

    public void updateReference() {
        this.reference = new WeakReference<ItemStack>(this.it);
    }

    public String getTitle() {
        return this.title;
    }

    public void setItem(@NotNull ItemStack item) {
        String name = ShulkerUtils.getShulkerName(item);
        if (!name.equals(this.title)) {
            this.updateGuiTitle(name);
        }
        this.it = item;
    }

    public void updateGuiTitle() {
        ItemMeta meta = this.it.getItemMeta();
        String name = meta == null ? ColorUtils.format(AxShulkers.MESSAGES.getString("shulker-title")) : meta.getDisplayName();
        this.updateGuiTitle(name);
    }

    public void updateGuiTitle(@NotNull String name) {
        this.title = name;
        ArrayList viewers = new ArrayList(this.shulkerInventory.getViewers());
        Inventory shulkerInv = Bukkit.createInventory(null, (InventoryType)InventoryType.SHULKER_BOX, (String)ColorUtils.format(this.title));
        shulkerInv.setContents(this.shulkerInventory.getContents());
        this.shulkerInventory = shulkerInv;
        for (HumanEntity viewer : viewers) {
            viewer.closeInventory();
        }
    }

    public void close() {
        ArrayList viewers = new ArrayList(this.shulkerInventory.getViewers());
        for (HumanEntity viewer : viewers) {
            viewer.closeInventory();
        }
    }
}

