/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axshulkers;

import com.artillexstudios.axshulkers.cache.Shulkerbox;
import com.artillexstudios.axshulkers.cache.Shulkerboxes;
import com.artillexstudios.axshulkers.commands.Commands;
import com.artillexstudios.axshulkers.commands.TabComplete;
import com.artillexstudios.axshulkers.config.AbstractConfig;
import com.artillexstudios.axshulkers.config.impl.Config;
import com.artillexstudios.axshulkers.config.impl.Messages;
import com.artillexstudios.axshulkers.database.Database;
import com.artillexstudios.axshulkers.database.DatabaseQueue;
import com.artillexstudios.axshulkers.database.impl.H2;
import com.artillexstudios.axshulkers.database.impl.SQLite;
import com.artillexstudios.axshulkers.libraries.Libraries;
import com.artillexstudios.axshulkers.libs.BukkitLibraryManager;
import com.artillexstudios.axshulkers.libs.boostedyaml.YamlDocument;
import com.artillexstudios.axshulkers.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axshulkers.libs.folialib.FoliaLib;
import com.artillexstudios.axshulkers.libs.folialib.impl.PlatformScheduler;
import com.artillexstudios.axshulkers.listeners.Listeners;
import com.artillexstudios.axshulkers.safety.SafetyManager;
import com.artillexstudios.axshulkers.schedulers.AutoSaveScheduler;
import com.artillexstudios.axshulkers.utils.ColorUtils;
import com.artillexstudios.axshulkers.utils.UpdateNotifier;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AxShulkers
extends JavaPlugin {
    private static AbstractConfig abstractConfig;
    private static AbstractConfig abstractMessages;
    public static YamlDocument MESSAGES;
    public static YamlDocument CONFIG;
    private static AxShulkers instance;
    private static DatabaseQueue databaseQueue;
    private static Database database;
    public static FoliaLib foliaLib;

    public static AbstractConfig getAbstractConfig() {
        return abstractConfig;
    }

    public static AbstractConfig getAbstractMessages() {
        return abstractMessages;
    }

    public static AxShulkers getInstance() {
        return instance;
    }

    public static Database getDB() {
        return database;
    }

    public static DatabaseQueue getDatabaseQueue() {
        return databaseQueue;
    }

    public static PlatformScheduler getScheduler() {
        return foliaLib.getScheduler();
    }

    public void onLoad() {
        BukkitLibraryManager libraryManager = new BukkitLibraryManager((Plugin)this, "libraries");
        libraryManager.addMavenCentral();
        libraryManager.addJitPack();
        libraryManager.addRepository("https://repo.codemc.io/repository/maven-public/");
        libraryManager.addRepository("https://repo.papermc.io/repository/maven-public/");
        for (Libraries lib : Libraries.values()) {
            libraryManager.loadLibrary(lib.getLibrary());
        }
    }

    public void onEnable() {
        instance = this;
        foliaLib = new FoliaLib(this);
        new Metrics((Plugin)this, 19570);
        abstractConfig = new Config();
        abstractConfig.setup();
        CONFIG = abstractConfig.getConfig();
        abstractMessages = new Messages();
        abstractMessages.setup();
        MESSAGES = abstractMessages.getConfig();
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "h2": {
                database = new H2();
                break;
            }
            default: {
                database = new SQLite();
            }
        }
        database.setup();
        databaseQueue = new DatabaseQueue("AxShulkers-Datastore-thread");
        Listeners.register();
        AutoSaveScheduler.start();
        SafetyManager.start();
        PluginCommand command = this.getCommand("axshulkers");
        command.setExecutor((CommandExecutor)new Commands());
        command.setTabCompleter((TabCompleter)new TabComplete());
        Bukkit.getConsoleSender().sendMessage(ColorUtils.format("&#CC00FF[AxShulkers] Loaded plugin! Using &f" + database.getType() + " &#CC00FFdatabase to store data!"));
        if (CONFIG.getBoolean("update-notifier.enabled", (Boolean)true).booleanValue()) {
            new UpdateNotifier(this, 4666);
        }
    }

    public void onDisable() {
        AutoSaveScheduler.stop();
        SafetyManager.stop();
        for (Shulkerbox shulkerbox : Shulkerboxes.getShulkerMap().values()) {
            AxShulkers.getDB().updateShulker(shulkerbox.getShulkerInventory().getContents(), shulkerbox.getUUID());
            shulkerbox.close();
        }
        database.disable();
    }
}

