/*
 * Decompiled with CFR 0.152.
 */
package revxrsal.zapper.classloader;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.Field;
import java.util.Objects;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Supplier<Unsafe> Unsafe = Suppliers.memoize(() -> {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            return (Unsafe)field.get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    });
    private static final Supplier<Boolean> isJava8 = Suppliers.memoize(() -> {
        String version = System.getProperty("java.version");
        return version.contains("1.8");
    });

    UnsafeUtil() {
    }

    public static Unsafe getUnsafe() {
        return (Unsafe)Unsafe.get();
    }

    public static boolean isJava8() {
        return (Boolean)isJava8.get();
    }

    public static <T> T getField(Object instance, String name, Class<?> from) {
        return Objects.requireNonNull(UnsafeUtil.getFieldNullable(instance, name, from), "getField(" + name + ") from " + from);
    }

    public static <T> T getFieldNullable(Object instance, String name, Class<?> from) {
        try {
            Unsafe unsafe = (Unsafe)Unsafe.get();
            Field field = from.getDeclaredField(name);
            long offset = unsafe.objectFieldOffset(field);
            Object value = unsafe.getObject(instance, offset);
            return (T)value;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> void setField(Object instance, String name, Class<?> from, T value) {
        try {
            Unsafe unsafe = (Unsafe)Unsafe.get();
            Field field = from.getDeclaredField(name);
            long offset = unsafe.objectFieldOffset(field);
            unsafe.putObject(instance, offset, value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static <T> T getFieldReflection(Object instance, String name, Class<?> from) {
        try {
            Field field = from.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

