/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.utils;

import com.artillexstudios.axsellwands.AxSellwands;
import com.artillexstudios.axsellwands.libs.axapi.hologram.Hologram;
import com.artillexstudios.axsellwands.libs.axapi.hologram.HologramType;
import com.artillexstudios.axsellwands.libs.axapi.hologram.HologramTypes;
import com.artillexstudios.axsellwands.libs.axapi.hologram.page.HologramPage;
import com.artillexstudios.axsellwands.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axsellwands.libs.axapi.packetentity.meta.entity.DisplayMeta;
import com.artillexstudios.axsellwands.libs.axapi.packetentity.meta.entity.TextDisplayMeta;
import com.artillexstudios.axsellwands.libs.axapi.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class HologramUtils {
    public static void spawnHologram(@NotNull Player player, @NotNull Location location, HashMap<String, String> replacements) {
        Vector diff = location.toVector().subtract(player.getLocation().toVector());
        diff.subtract(diff.clone().normalize());
        location = player.getLocation().toVector().add(diff).toLocation(location.getWorld());
        Hologram hologram = new Hologram(location);
        HologramPage<String, HologramType<String>> page = hologram.createPage(HologramTypes.TEXT);
        Section section = AxSellwands.CONFIG.getSection("hologram");
        page.setEntityMetaHandler(m -> {
            TextDisplayMeta meta = (TextDisplayMeta)m;
            meta.seeThrough(section.getBoolean("see-through"));
            meta.alignment(TextDisplayMeta.Alignment.valueOf(section.getString("alignment").toUpperCase()));
            meta.backgroundColor(Integer.parseInt(section.getString("background-color"), 16));
            meta.lineWidth(1000);
            meta.billboardConstrain(DisplayMeta.BillboardConstrain.valueOf(section.getString("billboard").toUpperCase()));
        });
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : AxSellwands.LANG.getStringList("sell-hologram")) {
            for (Map.Entry<String, String> entry : replacements.entrySet()) {
                line = line.replace(entry.getKey(), entry.getValue());
            }
            lines.add(line);
        }
        page.setContent(String.join((CharSequence)"<reset><br>", lines));
        page.spawn();
        Scheduler.get().runLaterAt(location, scheduledTask -> hologram.remove(), (long)AxSellwands.CONFIG.getInt("hologram.stay-time-ticks", 30));
    }
}

