/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.sellwands;

import com.artillexstudios.axsellwands.libs.axapi.config.Config;
import com.artillexstudios.axsellwands.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axsellwands.libs.axapi.utils.StringUtils;
import java.util.HashSet;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;

public class Sellwand {
    private final String id;
    private final Config file;
    private final String name;
    private final float multiplier;
    private final int uses;
    private final long cooldown;
    private final Section itemSection;
    private final HashSet<Material> disallowed = new HashSet();
    private final HashSet<Material> allowed = new HashSet();

    public Sellwand(String id, @NotNull Config file) {
        Material material;
        this.id = id;
        this.file = file;
        long configMillis = file.getLong("cooldown-miliseconds", -1L);
        if (configMillis != -1L) {
            file.getBackingDocument().remove("cooldown-miliseconds");
            file.set("cooldown-milliseconds", configMillis);
            file.save();
        }
        this.name = file.getString("name", "Sellwand");
        this.multiplier = file.getFloat("multiplier", 1.0f);
        this.uses = file.getInt("uses", -1);
        this.cooldown = file.getLong("cooldown-milliseconds", 0L);
        this.itemSection = file.getSection("item");
        for (String str : file.getStringList("disallowed-containers")) {
            material = Material.getMaterial((String)str);
            if (material == null) {
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF5500[AxSellwands] Material " + str + " does not exists, skipping!", new TagResolver[0]));
                continue;
            }
            this.disallowed.add(material);
        }
        for (String str : file.getStringList("allowed-containers")) {
            material = Material.getMaterial((String)str);
            if (material == null) {
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF5500[AxSellwands] Material " + str + " does not exists, skipping!", new TagResolver[0]));
                continue;
            }
            this.allowed.add(material);
        }
    }

    public String getId() {
        return this.id;
    }

    public Config getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public int getUses() {
        return this.uses;
    }

    public long getCooldown() {
        return this.cooldown;
    }

    public Section getItemSection() {
        return this.itemSection;
    }

    public HashSet<Material> getDisallowed() {
        return this.disallowed;
    }

    public HashSet<Material> getAllowed() {
        return this.allowed;
    }
}

