/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.nms.v1_21_R7_paper.wrapper;

import com.artillexstudios.axsellwands.libs.axapi.items.HashGenerator;
import com.artillexstudios.axsellwands.libs.axapi.nms.v1_21_R7_paper.packet.ChannelDuplexHandlerPacketListener;
import com.artillexstudios.axsellwands.libs.axapi.nms.v1_21_R7_paper.packet.PacketTransformer;
import com.artillexstudios.axsellwands.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axsellwands.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axsellwands.libs.axapi.utils.ComponentSerializer;
import com.artillexstudios.axsellwands.libs.axapi.utils.PlayerTextures;
import com.artillexstudios.axsellwands.libs.axapi.utils.logging.LogUtils;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.inventory.ContainerSynchronizer;
import org.bukkit.attribute.Attribute;
import org.bukkit.craftbukkit.attribute.CraftAttribute;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public final class ServerPlayerWrapper
implements com.artillexstudios.axsellwands.libs.axapi.nms.wrapper.ServerPlayerWrapper {
    private static final FieldAccessor connectionAccessor = FieldAccessor.builder().withClass("net.minecraft.server.network.ServerCommonPacketListenerImpl").withField("connection").build();
    private static final FieldAccessor channelAccessor = FieldAccessor.builder().withClass("net.minecraft.network.Connection").withField("channel").build();
    private static final FieldAccessor attributeAccessor = FieldAccessor.builder().withClass(AttributeMap.class).withField("supplier").build();
    private static final FieldAccessor containerSynchronizerAccessor = FieldAccessor.builder().withClass(ServerPlayer.class).withField("containerSynchronizer").build();
    private static final FieldAccessor cacheAccessor = FieldAccessor.builder().withClass("net.minecraft.server.level.ServerPlayer$1").withField("cache").build();
    private final PacketTransformer transformer;
    private LoadingCache<Object, Integer> cache;
    private Player wrapped;
    private ServerPlayer serverPlayer;

    public ServerPlayerWrapper(Player player) {
        this.wrapped = player;
        this.transformer = new PacketTransformer(this);
    }

    public ServerPlayerWrapper(ServerPlayer player) {
        this.serverPlayer = player;
        this.transformer = new PacketTransformer(this);
    }

    @Override
    public void inject() {
        this.update();
        Connection connection = connectionAccessor.get(this.serverPlayer.connection, Connection.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        if (!channel.pipeline().names().contains("packet_handler")) {
            return;
        }
        if (channel.pipeline().names().contains(AXAPI_HANDLER)) {
            return;
        }
        channel.eventLoop().submit(() -> channel.pipeline().addBefore("packet_handler", AXAPI_HANDLER, (ChannelHandler)new ChannelDuplexHandlerPacketListener(this)));
    }

    @Override
    public void uninject() {
        this.update();
        Connection connection = connectionAccessor.get(this.serverPlayer.connection, Connection.class);
        Channel channel = channelAccessor.get(connection, Channel.class);
        channel.eventLoop().submit(() -> {
            if (channel.pipeline().get(AXAPI_HANDLER) != null) {
                channel.pipeline().remove(AXAPI_HANDLER);
            }
        });
    }

    @Override
    public void sendPacket(Object packet) {
        this.update();
        if (packet instanceof PacketWrapper) {
            PacketWrapper wrapper = (PacketWrapper)packet;
            this.serverPlayer.connection.send((Packet)wrapper.cached());
            return;
        }
        if (!(packet instanceof Packet)) {
            LogUtils.warn("Failed to send unknown packet to player {}! Packet: {}", this.wrapped().getName(), packet);
            return;
        }
        Packet p = (Packet)packet;
        this.serverPlayer.connection.send(p);
    }

    @Override
    public void message(net.kyori.adventure.text.Component message) {
        this.update();
        this.serverPlayer.connection.send((Packet)new ClientboundSystemChatPacket((Component)ComponentSerializer.INSTANCE.toVanilla(message), false));
    }

    @Override
    public double getBase(Attribute attribute) {
        this.update();
        AttributeMap map = this.serverPlayer.getAttributes();
        AttributeSupplier supplier = attributeAccessor.get(map, AttributeSupplier.class);
        return supplier.getBaseValue(CraftAttribute.bukkitToMinecraftHolder((Attribute)attribute));
    }

    @Override
    public PlayerTextures textures() {
        this.update();
        GameProfile profile = this.serverPlayer.getGameProfile();
        Optional property = profile.properties().get((Object)"textures").stream().findFirst();
        if (property.isEmpty()) {
            return new PlayerTextures(null, null);
        }
        Property value = (Property)property.get();
        return new PlayerTextures(value.value(), value.signature());
    }

    @Override
    public double getX() {
        this.update();
        return this.serverPlayer.getX();
    }

    @Override
    public double getZ() {
        this.update();
        return this.serverPlayer.getZ();
    }

    @Override
    public HashGenerator hashGenerator() {
        this.update();
        return typed -> (Integer)this.cache.getUnchecked(typed);
    }

    @Override
    public Player wrapped() {
        Player wrapped = this.wrapped;
        if (wrapped == null) {
            this.wrapped = wrapped = this.serverPlayer.getBukkitEntity();
        }
        return wrapped;
    }

    @Override
    public void update(boolean force) {
        if (this.serverPlayer == null || force) {
            this.serverPlayer = ((CraftPlayer)this.wrapped).getHandle();
            ContainerSynchronizer synchronizer = containerSynchronizerAccessor.get(this.serverPlayer, ContainerSynchronizer.class);
            this.cache = (LoadingCache)cacheAccessor.getUnchecked(synchronizer);
        }
    }

    public ServerPlayer asMinecraft() {
        this.update();
        return this.serverPlayer;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ServerPlayerWrapper)) {
            return false;
        }
        ServerPlayerWrapper that = (ServerPlayerWrapper)o;
        this.update();
        that.update();
        if (Objects.equals(this.serverPlayer, that.serverPlayer)) {
            return true;
        }
        return this.wrapped().getUniqueId().equals(that.wrapped().getUniqueId());
    }

    public int hashCode() {
        this.update();
        return Objects.hashCode(this.serverPlayer);
    }
}

