/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.nms.v1_21_R7_paper;

import com.artillexstudios.axsellwands.libs.axapi.libs.math3.distribution.EnumeratedDistribution;
import com.artillexstudios.axsellwands.libs.axapi.selection.Cuboid;
import com.artillexstudios.axsellwands.libs.axapi.selection.ParallelBlockSetter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntConsumer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.block.data.CraftBlockData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelBlockSetterImpl
implements ParallelBlockSetter {
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final ExecutorService parallelExecutor = Executors.newVirtualThreadPerTaskExecutor();
    private static final Logger log = LoggerFactory.getLogger(ParallelBlockSetterImpl.class);
    private final ServerLevel level;

    public ParallelBlockSetterImpl(ServerLevel level) {
        this.level = level;
    }

    public LevelChunkSection copy(LevelChunkSection section) {
        try {
            Constructor constructor = LevelChunkSection.class.getDeclaredConstructor(LevelChunkSection.class);
            constructor.setAccessible(true);
            LevelChunkSection newSection = (LevelChunkSection)constructor.newInstance(section);
            return newSection;
        }
        catch (Exception exception) {
            log.error("An unexpected issue occurred while initializing ParallelBlockSetter. Is your version supported?", (Throwable)exception);
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void fill(Cuboid selection, EnumeratedDistribution<BlockData> distribution, IntConsumer consumer) {
        AtomicInteger blockCount = new AtomicInteger();
        int chunkMinX = selection.getMinX() >> 4;
        int chunkMaxX = selection.getMaxX() >> 4;
        int chunkMinZ = selection.getMinZ() >> 4;
        int chunkMaxZ = selection.getMaxZ() >> 4;
        List pmf = distribution.getPmf();
        ArrayList<CompletableFuture<Void>> chunkTasks = new ArrayList<CompletableFuture<Void>>();
        for (int chunkX = chunkMinX; chunkX <= chunkMaxX; ++chunkX) {
            int minX = Math.max(selection.getMinX(), chunkX << 4);
            int maxX = Math.min(selection.getMaxX(), (chunkX << 4) + 15);
            for (int chunkZ = chunkMinZ; chunkZ <= chunkMaxZ; ++chunkZ) {
                int minZ = Math.max(selection.getMinZ(), chunkZ << 4);
                int maxZ = Math.min(selection.getMaxZ(), (chunkZ << 4) + 15);
                LevelChunk levelChunk = this.level.getChunk(chunkX, chunkZ);
                ArrayList<CompletableFuture<Void>> chunkFutures = new ArrayList<CompletableFuture<Void>>();
                int lastSectionIndex = -1;
                for (int y = selection.getMinY(); y <= selection.getMaxY(); ++y) {
                    int sectionIndex = levelChunk.getSectionIndex(y);
                    if (lastSectionIndex == sectionIndex) continue;
                    lastSectionIndex = sectionIndex;
                    LevelChunkSection section = levelChunk.getSection(sectionIndex);
                    LevelChunkSection newSection = this.copy(section);
                    CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                        EnumeratedDistribution newDistribution = new EnumeratedDistribution(pmf);
                        for (int i = selection.getMinY(); i <= selection.getMaxY(); ++i) {
                            int m = levelChunk.getSectionIndex(i);
                            if (m < sectionIndex) continue;
                            if (m > sectionIndex) break;
                            for (int x = minX; x <= maxX; ++x) {
                                for (int z = minZ; z <= maxZ; ++z) {
                                    CraftBlockData type = (CraftBlockData)newDistribution.sample();
                                    int j = x & 0xF;
                                    int k = i & 0xF;
                                    int l = z & 0xF;
                                    BlockState state = type.getState();
                                    blockCount.incrementAndGet();
                                    newSection.setBlockState(j, k, l, state, true);
                                    this.updateHeightMap((ChunkAccess)levelChunk, j, i, l, state);
                                }
                            }
                        }
                        try {
                            MinecraftServer.getServer().submit(() -> {
                                levelChunk.getSections()[sectionIndex] = newSection;
                            }).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            throw new RuntimeException(e);
                        }
                    }, parallelExecutor);
                    chunkFutures.add(future);
                }
                CompletableFuture<Void> thisChunk = CompletableFuture.allOf(chunkFutures.toArray(new CompletableFuture[0]));
                thisChunk.thenAccept(ignored -> MinecraftServer.getServer().submit(() -> {
                    ThreadedLevelLightEngine lightEngine = this.level.chunkSource.getLightEngine();
                    levelChunk.markUnsaved();
                    this.sendUpdatePacket(levelChunk);
                }));
                chunkTasks.add(thisChunk);
            }
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(chunkTasks.toArray(new CompletableFuture[0]));
        future.thenAccept(ignored -> consumer.accept(blockCount.get()));
    }

    private void sendUpdatePacket(@NotNull LevelChunk chunk) {
        ChunkHolder playerChunk = this.level.getChunkSource().chunkMap.getVisibleChunkIfPresent(chunk.getPos().longKey);
        if (playerChunk == null) {
            return;
        }
        List playersInRange = playerChunk.playerProvider.getPlayers(playerChunk.getPos(), false);
    }

    private void updateHeightMap(ChunkAccess chunk, int x, int y, int z, BlockState blockState) {
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.MOTION_BLOCKING)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.OCEAN_FLOOR)).update(x, y, z, blockState);
        ((Heightmap)chunk.heightmaps.get(Heightmap.Types.WORLD_SURFACE)).update(x, y, z, blockState);
    }
}

