/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.nms.v1_20_R3.packet;

import com.artillexstudios.axsellwands.libs.axapi.nms.v1_20_R3.packet.FriendlyByteBufWrapper;
import com.artillexstudios.axsellwands.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axsellwands.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axsellwands.libs.axapi.packet.PacketSide;
import com.artillexstudios.axsellwands.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axsellwands.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axsellwands.libs.axapi.reflection.FieldAccessor;
import com.artillexstudios.axsellwands.libs.axapi.utils.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;

public final class PacketTransformer {
    private static final FieldAccessor packetSetAccessor = FieldAccessor.builder().withClass(EnumProtocol.a.class).withField("c").build();
    private static final FieldAccessor classToIdAccessor = FieldAccessor.builder().withClass("net.minecraft.network.EnumProtocol$b").withField("b").build();
    private static final EnumProtocol.a<?> clientboundCodec = EnumProtocol.b.b(EnumProtocolDirection.b);
    private static final EnumProtocol.a<?> serverboundCodec = EnumProtocol.b.b(EnumProtocolDirection.a);

    public static Packet<?> transformClientbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(new PacketDataSerializer(Unpooled.buffer()));
        buf.writeVarInt(ClientboundPacketTypes.forPacketType(wrapper.packetType()));
        wrapper.write(buf);
        return PacketTransformer.transformClientbound(buf.buf());
    }

    public static Packet<?> transformClientbound(FriendlyByteBuf buf) {
        return PacketTransformer.transformClientbound(((FriendlyByteBufWrapper)buf).buf());
    }

    public static Packet<PacketListenerPlayOut> transformClientbound(PacketDataSerializer buf) {
        try {
            Packet packet = clientboundCodec.a(buf.n(), buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<PacketListenerPlayOut> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static Packet<PacketListenerPlayIn> transformServerbound(PacketDataSerializer buf) {
        try {
            Packet packet = serverboundCodec.a(buf.n(), buf);
            return packet;
        }
        catch (Exception exception) {
            LogUtils.error("Failed to transform packet!", exception);
            Packet<PacketListenerPlayIn> packet = null;
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static Packet<?> transformServerbound(PacketWrapper wrapper) {
        FriendlyByteBufWrapper buf = new FriendlyByteBufWrapper(new PacketDataSerializer(Unpooled.buffer()));
        wrapper.write(buf);
        return PacketTransformer.transformServerbound0(buf.buf());
    }

    public static Packet<?> transformServerbound(FriendlyByteBuf buf) {
        return PacketTransformer.transformServerbound0(((FriendlyByteBufWrapper)buf).buf());
    }

    private static Packet<?> transformServerbound0(PacketDataSerializer buf) {
        try {
            Packet packet = serverboundCodec.a(buf.n(), buf);
            return packet;
        }
        finally {
            buf.release();
        }
    }

    public static FriendlyByteBuf transformServerbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return PacketTransformer.transformServerbound(ctx, packet, buf -> {});
    }

    public static FriendlyByteBuf transformServerbound(Packet<?> packet) {
        return PacketTransformer.transformServerbound(null, packet, buf -> {});
    }

    public static FriendlyByteBuf transformServerbound(Packet<?> packet, Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.transformServerbound(null, packet, consumer);
    }

    public static FriendlyByteBufWrapper transformServerbound(ChannelHandlerContext ctx, Object packet, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            Packet packetObject = (Packet)packet;
            PacketDataSerializer buffer = new PacketDataSerializer(PacketTransformer.alloc(ctx));
            packetObject.a(buffer);
            wrapper = new FriendlyByteBufWrapper(buffer);
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(new PacketDataSerializer(buffer.copy()));
            wrapper.readVarInt();
        } else {
            LogUtils.error("Unhandled packet class: {} Pipeline: {}", packet.getClass(), ctx.channel().pipeline().names());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public static FriendlyByteBuf transformClientbound(ChannelHandlerContext ctx, Packet<?> packet) {
        return PacketTransformer.transformClientbound(ctx, packet, buf -> {});
    }

    public static FriendlyByteBuf transformClientbound(Packet<?> packet) {
        return PacketTransformer.transformClientbound(null, packet, buf -> {});
    }

    public static FriendlyByteBuf transformClientbound(Packet<?> packet, Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.transformClientbound(null, packet, consumer);
    }

    public static FriendlyByteBufWrapper transformClientbound(ChannelHandlerContext ctx, Object packet, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper;
        if (packet instanceof Packet) {
            Packet packetObject = (Packet)packet;
            PacketDataSerializer buffer = new PacketDataSerializer(PacketTransformer.alloc(ctx));
            packetObject.a(buffer);
            wrapper = new FriendlyByteBufWrapper(buffer);
        } else if (packet instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)packet;
            wrapper = new FriendlyByteBufWrapper(new PacketDataSerializer(buffer.copy()));
            wrapper.readVarInt();
        } else {
            LogUtils.error("Unhandled packet class: {} Pipeline: {}", packet.getClass(), ctx.channel().pipeline().names());
            return null;
        }
        consumer.accept(wrapper);
        return wrapper;
    }

    public static FriendlyByteBuf newByteBuf() {
        return PacketTransformer.newByteBuf(null, buf -> {});
    }

    public static FriendlyByteBuf newByteBuf(ChannelHandlerContext ctx) {
        return PacketTransformer.newByteBuf(ctx, buf -> {});
    }

    public static FriendlyByteBuf newByteBuf(Consumer<FriendlyByteBuf> consumer) {
        return PacketTransformer.newByteBuf(null, consumer);
    }

    public static FriendlyByteBuf newByteBuf(ChannelHandlerContext ctx, Consumer<FriendlyByteBuf> consumer) {
        FriendlyByteBufWrapper wrapper = new FriendlyByteBufWrapper(new PacketDataSerializer(PacketTransformer.alloc(ctx)));
        consumer.accept(wrapper);
        return wrapper;
    }

    public static ByteBuf alloc() {
        return PacketTransformer.alloc(null);
    }

    public static ByteBuf alloc(ChannelHandlerContext ctx) {
        return ctx == null ? Unpooled.buffer() : ctx.alloc().buffer();
    }

    public static int packetId(PacketSide side, Object input) {
        int packetId;
        if (input instanceof Packet) {
            Packet packet = (Packet)input;
            int packetId2 = side == PacketSide.CLIENT_BOUND ? clientboundCodec.a(packet) : serverboundCodec.a(packet);
            return packetId2;
        }
        if (input instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)input;
            int readerIndex = buffer.readerIndex();
            int writerIndex = buffer.writerIndex();
            packetId = VarInt.a((ByteBuf)buffer);
            buffer.readerIndex(readerIndex);
            buffer.writerIndex(writerIndex);
        } else {
            LogUtils.warn("Unhandled packet class: {}", ClassUtils.INSTANCE.debugClass(input.getClass()));
            packetId = -1;
        }
        return packetId;
    }

    public static FriendlyByteBuf wrap(ByteBuf buf) {
        return new FriendlyByteBufWrapper(new PacketDataSerializer(buf));
    }

    public static FriendlyByteBuf copy(FriendlyByteBufWrapper friendlyByteBufWrapper) {
        return PacketTransformer.wrap(friendlyByteBufWrapper.buf().copy());
    }
}

