/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.executor;

import com.google.common.collect.Queues;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedExecutor
implements Runnable,
Executor {
    private static final Logger log = LoggerFactory.getLogger(ThreadedExecutor.class);
    private final Queue<Runnable> jobs = Queues.newArrayDeque();
    private final Thread thread;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean killed = false;

    public ThreadedExecutor(String threadName) {
        this.thread = new Thread((Runnable)this, threadName);
        this.thread.start();
    }

    public void stop() {
        this.killed = true;
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void execute(Runnable task) {
        this.lock.lock();
        try {
            this.jobs.offer(task);
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    public CompletableFuture<Void> submit(Runnable task) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.execute(() -> {
            try {
                task.run();
            }
            catch (Throwable throwable) {
                future.completeExceptionally(throwable);
                return;
            }
            future.complete(null);
        });
        return future;
    }

    @Override
    public void run() {
        while (!this.killed) {
            try {
                Runnable next = this.next();
                if (next == null) continue;
                next.run();
            }
            catch (Exception exception) {
                log.error("An unexpected error occurred while running ThreadedExecutor {}!", (Object)this.thread.getName(), (Object)exception);
            }
        }
    }

    public Runnable next() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.jobs.isEmpty() && !this.killed) {
                this.condition.await();
            }
            if (this.jobs.isEmpty()) {
                Runnable runnable = null;
                return runnable;
            }
            Runnable runnable = this.jobs.remove();
            return runnable;
        }
        finally {
            this.lock.unlock();
        }
    }
}

