/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.hooks;

import com.artillexstudios.axsellwands.AxSellwands;
import com.artillexstudios.axsellwands.hooks.container.ContainerHook;
import com.artillexstudios.axsellwands.hooks.currency.CoinsEngineHook;
import com.artillexstudios.axsellwands.hooks.currency.CurrencyHook;
import com.artillexstudios.axsellwands.hooks.currency.PlayerPointsHook;
import com.artillexstudios.axsellwands.hooks.currency.RoyaleEconomyHook;
import com.artillexstudios.axsellwands.hooks.currency.VaultHook;
import com.artillexstudios.axsellwands.hooks.other.Placeholders;
import com.artillexstudios.axsellwands.hooks.protection.BentoBoxHook;
import com.artillexstudios.axsellwands.hooks.protection.GriefPreventionHook;
import com.artillexstudios.axsellwands.hooks.protection.HuskClaimsHook;
import com.artillexstudios.axsellwands.hooks.protection.HuskTownsHook;
import com.artillexstudios.axsellwands.hooks.protection.IridiumSkyBlockHook;
import com.artillexstudios.axsellwands.hooks.protection.KingdomsXHook;
import com.artillexstudios.axsellwands.hooks.protection.LandsHook;
import com.artillexstudios.axsellwands.hooks.protection.PlotSquaredHook;
import com.artillexstudios.axsellwands.hooks.protection.ProtectionHook;
import com.artillexstudios.axsellwands.hooks.protection.ResidenceHook;
import com.artillexstudios.axsellwands.hooks.protection.SaberFactionsHook;
import com.artillexstudios.axsellwands.hooks.protection.SuperiorSkyBlock2Hook;
import com.artillexstudios.axsellwands.hooks.protection.TownyHook;
import com.artillexstudios.axsellwands.hooks.protection.WorldGuardHook;
import com.artillexstudios.axsellwands.hooks.shop.AxGensHook;
import com.artillexstudios.axsellwands.hooks.shop.BuiltinPrices;
import com.artillexstudios.axsellwands.hooks.shop.CMIPricesHook;
import com.artillexstudios.axsellwands.hooks.shop.DynamicShop3Hook;
import com.artillexstudios.axsellwands.hooks.shop.EconomyShopGuiHook;
import com.artillexstudios.axsellwands.hooks.shop.EssentialsHook;
import com.artillexstudios.axsellwands.hooks.shop.ExcellentShopHook;
import com.artillexstudios.axsellwands.hooks.shop.PricesHook;
import com.artillexstudios.axsellwands.hooks.shop.ShopGUIPlusHook;
import com.artillexstudios.axsellwands.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axsellwands.libs.axapi.utils.StringUtils;
import java.util.HashSet;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HookManager {
    private static CurrencyHook currency = null;
    private static PricesHook shopPrices = null;
    private static final HashSet<ContainerHook> CONTAINER_HOOKS = new HashSet();
    private static final HashSet<ProtectionHook> PROTECTION_HOOKS = new HashSet();

    public static void setupHooks() {
        HookManager.updateHooks();
        if (AxSellwands.HOOKS.getBoolean("hook-settings.PlaceholderAPI.register", true) && Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new Placeholders().register();
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.IridiumSkyBlock.register", true) && Bukkit.getPluginManager().getPlugin("IridiumSkyBlock") != null) {
            PROTECTION_HOOKS.add(new IridiumSkyBlockHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into IridiumSkyBlock!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.SuperiorSkyblock2.register", true) && Bukkit.getPluginManager().getPlugin("SuperiorSkyblock2") != null) {
            PROTECTION_HOOKS.add(new SuperiorSkyBlock2Hook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into SuperiorSkyblock2!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.WorldGuard.register", true) && Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            PROTECTION_HOOKS.add(new WorldGuardHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into WorldGuard!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.Kingdoms.register", true) && Bukkit.getPluginManager().getPlugin("Kingdoms") != null) {
            PROTECTION_HOOKS.add(new KingdomsXHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Kingdoms!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.BentoBox.register", true) && Bukkit.getPluginManager().getPlugin("BentoBox") != null) {
            PROTECTION_HOOKS.add(new BentoBoxHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into BentoBox!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.GriefPrevention.register", true) && Bukkit.getPluginManager().getPlugin("GriefPrevention") != null) {
            PROTECTION_HOOKS.add(new GriefPreventionHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into GriefPrevention!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.Lands.register", true) && Bukkit.getPluginManager().getPlugin("Lands") != null) {
            PROTECTION_HOOKS.add(new LandsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Lands!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.Residence.register", true) && Bukkit.getPluginManager().getPlugin("Residence") != null) {
            PROTECTION_HOOKS.add(new ResidenceHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Residence!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.PlotSquared.register", true) && Bukkit.getPluginManager().getPlugin("PlotSquared") != null) {
            PROTECTION_HOOKS.add(new PlotSquaredHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into PlotSquared!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.HuskTowns.register", true) && Bukkit.getPluginManager().getPlugin("HuskTowns") != null) {
            PROTECTION_HOOKS.add(new HuskTownsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into HuskTowns!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.HuskClaims.register", true) && Bukkit.getPluginManager().getPlugin("HuskClaims") != null) {
            PROTECTION_HOOKS.add(new HuskClaimsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into HuskClaims!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.Towny.register", true) && Bukkit.getPluginManager().getPlugin("Towny") != null) {
            PROTECTION_HOOKS.add(new TownyHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Towny!", new TagResolver[0]));
        }
        if (AxSellwands.HOOKS.getBoolean("hook-settings.SaberFactions.register", true) && ClassUtils.INSTANCE.classExists("com.massivecraft.factions.listeners.SaberGUIListener")) {
            PROTECTION_HOOKS.add(new SaberFactionsHook());
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into SaberFactions!", new TagResolver[0]));
        }
    }

    public static void updateHooks() {
        String shop;
        String eco;
        switch (eco = AxSellwands.HOOKS.getString("hooks.economy-plugin").toUpperCase()) {
            case "VAULT": {
                if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                    currency = new VaultHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Vault!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] Vault is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "PLAYERPOINTS": {
                if (Bukkit.getPluginManager().getPlugin("PlayerPoints") != null) {
                    currency = new PlayerPointsHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into PlayerPoints!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] PlayerPoints is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "COINSENGINE": {
                if (Bukkit.getPluginManager().getPlugin("CoinsEngine") != null) {
                    currency = new CoinsEngineHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into CoinsEngine!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] CoinsEngine is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "ROYALEECONOMY": {
                if (Bukkit.getPluginManager().getPlugin("RoyaleEconomy") != null) {
                    currency = new RoyaleEconomyHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into RoyaleEconomy!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] RoyaleEconomy is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
            }
        }
        if (currency != null) {
            currency.setup();
        }
        switch (shop = AxSellwands.HOOKS.getString("hooks.price-plugin").toUpperCase()) {
            case "AXGENS": {
                if (Bukkit.getPluginManager().getPlugin("AxGens") != null) {
                    shopPrices = new AxGensHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into AxGens!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] AxGens is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "SHOPGUIPLUS": {
                if (Bukkit.getPluginManager().getPlugin("ShopGUIPlus") != null) {
                    shopPrices = new ShopGUIPlusHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into ShopGUIPlus!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] ShopGUIPlus is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "ESSENTIALS": {
                if (Bukkit.getPluginManager().getPlugin("Essentials") != null) {
                    shopPrices = new EssentialsHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into Essentials!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] Essentials is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "CMI": {
                if (Bukkit.getPluginManager().getPlugin("CMI") != null) {
                    shopPrices = new CMIPricesHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into CMI (prices)!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] CMI is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "ECONOMYSHOPGUI": {
                if (Bukkit.getPluginManager().getPlugin("EconomyShopGUI") != null || Bukkit.getPluginManager().getPlugin("EconomyShopGUI-Premium") != null) {
                    shopPrices = new EconomyShopGuiHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into EconomyShopGUI!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] EconomyShopGUI is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "DYNAMICSHOP": {
                if (Bukkit.getPluginManager().getPlugin("DynamicShop") != null) {
                    shopPrices = new DynamicShop3Hook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into DynamicShop!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] DynamicShop is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            case "EXCELLENTSHOP": {
                if (Bukkit.getPluginManager().getPlugin("ExcellentShop") != null) {
                    shopPrices = new ExcellentShopHook();
                    Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into ExcellentShop!", new TagResolver[0]));
                    break;
                }
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] ExcellentShop is set in hooks.yml, but it is not installed, please download it or change it to stop errors!", new TagResolver[0]));
                break;
            }
            default: {
                shopPrices = new BuiltinPrices();
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Using builtin prices!", new TagResolver[0]));
            }
        }
        if (shopPrices != null) {
            shopPrices.setup();
        }
        if (HookManager.getShopPrices() == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] Shop prices hook not found! Please check your hooks.yml!", new TagResolver[0]));
        }
        if (HookManager.getCurrency() == null) {
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF3333[AxSellwands] Currency hook not found! Please check your hooks.yml!", new TagResolver[0]));
        }
    }

    public static void registerProtectionHook(@NotNull Plugin plugin, @NotNull ProtectionHook protectionHook) {
        PROTECTION_HOOKS.add(protectionHook);
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into " + plugin.getName() + "!", new TagResolver[0]));
    }

    public static void registerPriceProviderHook(@NotNull Plugin plugin, @NotNull PricesHook pricesHook) {
        shopPrices = pricesHook;
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into " + plugin.getName() + "! Note: You must set the price provider to CUSTOM or it will be overridden after reloading!", new TagResolver[0]));
    }

    public static void registerCurrencyHook(@NotNull Plugin plugin, @NotNull CurrencyHook currencyHook) {
        currency = currencyHook;
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#33FF33[AxSellwands] Hooked into " + plugin.getName() + "! Note: You must set the currency provider to CUSTOM or it will be overridden after reloading!", new TagResolver[0]));
    }

    @Nullable
    public static CurrencyHook getCurrency() {
        return currency;
    }

    @Nullable
    public static PricesHook getShopPrices() {
        return shopPrices;
    }

    @NotNull
    public static HashSet<ContainerHook> getContainerHooks() {
        return CONTAINER_HOOKS;
    }

    @NotNull
    public static HashSet<ProtectionHook> getProtectionHooks() {
        return PROTECTION_HOOKS;
    }

    public static boolean canBuildAt(@NotNull Player player, @NotNull Location location) {
        for (ProtectionHook hook : PROTECTION_HOOKS) {
            if (hook.canPlayerBuildAt(player, location)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static ContainerHook getContainerAt(@NotNull Player player, @NotNull Block block) {
        for (ContainerHook hook : CONTAINER_HOOKS) {
            if (!hook.isContainer(player, block)) continue;
            return hook;
        }
        return null;
    }
}

