/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.commands;

import com.artillexstudios.axsellwands.AxSellwands;
import com.artillexstudios.axsellwands.commands.Commands;
import com.artillexstudios.axsellwands.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axsellwands.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axsellwands.sellwands.Sellwand;
import com.artillexstudios.axsellwands.sellwands.Sellwands;
import com.artillexstudios.axsellwands.utils.CommandMessages;
import java.util.ArrayList;
import java.util.Locale;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private static BukkitCommandHandler handler = null;

    public static void load() {
        handler = BukkitCommandHandler.create((Plugin)AxSellwands.getInstance());
        handler.getTranslator().add(new CommandMessages());
        handler.setLocale(Locale.of("en", "US"));
        handler.getAutoCompleter().registerParameterSuggestions(Sellwand.class, (args, sender, command) -> {
            ArrayList suggestions = new ArrayList();
            Sellwands.getSellwands().forEach((id, sellwand) -> suggestions.add(id));
            if (!suggestions.isEmpty()) {
                return suggestions;
            }
            sender.error("There are no sellwands configured! If this is your first install, contact support or copy files from out github resources!");
            return suggestions;
        });
        handler.registerValueResolver(Sellwand.class, resolver -> {
            String str = resolver.popForParameter();
            if (Sellwands.getSellwands().containsKey(str)) {
                return Sellwands.getSellwands().get(str);
            }
            throw new CommandErrorException("invalid-command", str);
        });
        CommandManager.reload();
    }

    public static void reload() {
        handler.unregisterAllCommands();
        handler.register(new Commands());
        handler.registerBrigadier();
    }
}

