/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.utils;

import com.artillexstudios.axsellwands.AxSellwands;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class NumberUtils {
    private static NumberFormat formatter = new DecimalFormat(AxSellwands.CONFIG.getString("number-formatting.formatted", "#,###.##"));

    public static void reload() {
        int mode = AxSellwands.CONFIG.getInt("number-formatting.mode", 0);
        switch (mode) {
            case 0: {
                formatter = new DecimalFormat(AxSellwands.CONFIG.getString("number-formatting.formatted", "#,###.##"));
                break;
            }
            case 1: {
                String[] lang = AxSellwands.CONFIG.getString("number-formatting.short", "en_US").split("_");
                formatter = DecimalFormat.getCompactNumberInstance(new Locale(lang[0], lang[1]), NumberFormat.Style.SHORT);
                break;
            }
            case 2: {
                formatter = null;
            }
        }
    }

    public static String formatNumber(double number) {
        return formatter == null ? "" + number : formatter.format(number);
    }
}

