/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.listeners;

import com.artillexstudios.axsellwands.AxSellwands;
import com.artillexstudios.axsellwands.api.events.AxSellwandsSellEvent;
import com.artillexstudios.axsellwands.hooks.HookManager;
import com.artillexstudios.axsellwands.hooks.container.ContainerHook;
import com.artillexstudios.axsellwands.libs.axapi.items.NBTWrapper;
import com.artillexstudios.axsellwands.libs.axapi.utils.ActionBar;
import com.artillexstudios.axsellwands.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axsellwands.libs.axapi.utils.StringUtils;
import com.artillexstudios.axsellwands.libs.axapi.utils.Title;
import com.artillexstudios.axsellwands.sellwands.Sellwand;
import com.artillexstudios.axsellwands.sellwands.Sellwands;
import com.artillexstudios.axsellwands.utils.HistoryUtils;
import com.artillexstudios.axsellwands.utils.HologramUtils;
import com.artillexstudios.axsellwands.utils.NumberUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SellwandUseListener
implements Listener {
    @EventHandler(ignoreCancelled=true)
    public void onInteract(@NotNull PlayerInteractEvent event) {
        ItemStack[] contents;
        if (event.getItem() == null) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        NBTWrapper wrapper = new NBTWrapper(event.getItem());
        String type = wrapper.getString("axsellwands-type");
        if (type == null) {
            return;
        }
        Sellwand sellwand = Sellwands.getSellwands().get(type);
        event.setCancelled(true);
        if (sellwand == null) {
            return;
        }
        Player player = event.getPlayer();
        ContainerHook containerHook = HookManager.getContainerAt(player, block);
        if (containerHook != null) {
            contents = containerHook.getItems(player, block).toArray(new ItemStack[0]);
        } else if (block.getState() instanceof Container) {
            contents = ((Container)block.getState()).getInventory().getContents();
        } else if (block.getType() == Material.ENDER_CHEST) {
            contents = player.getEnderChest().getContents();
        } else {
            return;
        }
        boolean hasBypass = player.hasPermission("axsellwands.admin");
        if (!hasBypass && !HookManager.canBuildAt(player, block.getLocation())) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "no-permission", new TagResolver[0]);
            return;
        }
        if (sellwand.getDisallowed().contains(block.getType()) || !sellwand.getAllowed().isEmpty() && !sellwand.getAllowed().contains(block.getType())) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "disallowed-container", new TagResolver[0]);
            return;
        }
        Long lastUsed = wrapper.getLong("axsellwands-lastused");
        if (lastUsed != null && System.currentTimeMillis() - lastUsed < sellwand.getCooldown() && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "cooldown", Collections.singletonMap("%time%", Long.toString(Math.round((double)(sellwand.getCooldown() - System.currentTimeMillis() + lastUsed) / 1000.0))));
            return;
        }
        UUID uuid = wrapper.getUUID("axsellwands-uuid");
        float multiplier = wrapper.getFloatOr("axsellwands-multiplier", 1.0f).floatValue();
        int uses = wrapper.getIntOr("axsellwands-uses", -1);
        int maxUses = wrapper.getIntOr("axsellwands-max-uses", -1);
        int soldAmount = wrapper.getIntOr("axsellwands-sold-amount", 0);
        double soldPrice = wrapper.getDoubleOr("axsellwands-sold-price", 0.0);
        int newSoldAmount = 0;
        double newSoldPrice = 0.0;
        if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            HashMap<Material, Integer> items = new HashMap<Material, Integer>();
            for (ItemStack it : contents) {
                double d;
                if (it == null || (d = HookManager.getShopPrices().getPrice(player, it)) <= 0.0) continue;
                newSoldPrice += (d *= (double)multiplier);
                newSoldAmount += it.getAmount();
                if (items.containsKey(it.getType())) {
                    items.put(it.getType(), (Integer)items.get(it.getType()) + it.getAmount());
                } else {
                    items.put(it.getType(), it.getAmount());
                }
                it.setAmount(0);
            }
            if (newSoldAmount <= 0 || newSoldPrice <= 0.0) {
                AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "nothing-sold", new TagResolver[0]);
                return;
            }
            AxSellwandsSellEvent apiEvent = new AxSellwandsSellEvent(player, newSoldPrice, newSoldAmount);
            Bukkit.getPluginManager().callEvent((Event)apiEvent);
            if (apiEvent.isCancelled()) {
                return;
            }
            newSoldPrice = apiEvent.getMoneyMade();
            StringBuilder str = new StringBuilder("[");
            boolean first = true;
            for (Map.Entry entry : items.entrySet()) {
                if (!first) {
                    str.append(", ");
                }
                first = false;
                str.append(entry.getValue()).append("x ").append(((Material)entry.getKey()).name());
            }
            str.append("]");
            HistoryUtils.writeToHistory(String.format("%s sold %dx items %s and earned %s (multiplier: %s, uses: %d)", player.getName(), newSoldAmount, str, newSoldPrice, Float.valueOf(multiplier), uses - 1));
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("%amount%", "" + newSoldAmount);
            replacements.put("%price%", NumberUtils.formatNumber(newSoldPrice));
            HookManager.getCurrency().giveBalance(player, newSoldPrice);
            if (AxSellwands.CONFIG.getBoolean("hologram.enabled", true)) {
                HologramUtils.spawnHologram(player, block.getLocation().add(0.5, 0.5, 0.5), replacements);
            }
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "sell.chat", replacements);
            if (!AxSellwands.LANG.getString("sell.actionbar", "").isBlank()) {
                ActionBar.create(StringUtils.format(AxSellwands.LANG.getString("sell.actionbar"), replacements)).send(player);
            }
            if (AxSellwands.LANG.getSection("sell.title") != null && !AxSellwands.LANG.getString("sell.title.title").isBlank()) {
                Title.create(StringUtils.format(AxSellwands.LANG.getString("sell.title.title"), replacements), StringUtils.format(AxSellwands.LANG.getString("sell.title.subtitle"), replacements), 10, 40, 10).send(player);
            }
            if (!AxSellwands.LANG.getString("sounds.sell").isEmpty()) {
                player.playSound(player.getLocation(), Sound.valueOf((String)AxSellwands.LANG.getString("sounds.sell")), 1.0f, 1.0f);
            }
            if (!AxSellwands.LANG.getString("particles.sell").isEmpty()) {
                player.spawnParticle(Particle.valueOf((String)AxSellwands.LANG.getString("particles.sell")), block.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5);
            }
            if (uses != -1 && --uses < AxSellwands.CONFIG.getInt("minimum-durability", 1)) {
                event.getItem().setAmount(0);
                return;
            }
            replacements.clear();
            replacements.put("%multiplier%", "" + multiplier);
            replacements.put("%uses%", String.valueOf(uses == -1 ? AxSellwands.LANG.getString("unlimited", "\u221e") : Integer.valueOf(uses)));
            replacements.put("%max-uses%", String.valueOf(maxUses == -1 ? AxSellwands.LANG.getString("unlimited", "\u221e") : Integer.valueOf(maxUses)));
            replacements.put("%sold-amount%", "" + (soldAmount + newSoldAmount));
            replacements.put("%sold-price%", NumberUtils.formatNumber(soldPrice + newSoldPrice));
            Sellwand sellwand2 = Sellwands.getSellwands().get(type);
            ItemBuilder builder = ItemBuilder.create(sellwand2.getItemSection(), replacements);
            event.getItem().setItemMeta(builder.get().getItemMeta());
            wrapper = new NBTWrapper(event.getItem());
            wrapper.set("axsellwands-uuid", uuid);
            wrapper.set("axsellwands-uses", uses);
            wrapper.set("axsellwands-lastused", System.currentTimeMillis());
            wrapper.set("axsellwands-sold-amount", soldAmount + newSoldAmount);
            wrapper.set("axsellwands-sold-price", soldPrice + newSoldPrice);
            wrapper.set("axsellwands-type", type);
            wrapper.set("axsellwands-multiplier", multiplier);
            wrapper.set("axsellwands-max-uses", maxUses);
            wrapper.build();
            BlockState blockState = block.getState();
            if (blockState instanceof Container) {
                Container container = (Container)blockState;
                container.update();
            }
        } else {
            for (ItemStack it : contents) {
                double price;
                if (it == null || (price = HookManager.getShopPrices().getPrice(player, it)) == -1.0) continue;
                newSoldPrice += (price *= (double)multiplier);
                newSoldAmount += it.getAmount();
            }
            if (newSoldAmount <= 0 || newSoldPrice <= 0.0) {
                AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "nothing-sold", new TagResolver[0]);
                return;
            }
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("%amount%", "" + newSoldAmount);
            replacements.put("%price%", NumberUtils.formatNumber(newSoldPrice));
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "inspect.chat", replacements);
            if (!AxSellwands.LANG.getString("inspect.actionbar", "").isBlank()) {
                ActionBar.create(StringUtils.format(AxSellwands.LANG.getString("inspect.actionbar"), replacements)).send(player);
            }
            if (AxSellwands.LANG.getSection("inspect.title") != null && !AxSellwands.LANG.getString("inspect.title.title").isBlank()) {
                Title.create(StringUtils.format(AxSellwands.LANG.getString("inspect.title.title"), replacements), StringUtils.format(AxSellwands.LANG.getString("inspect.title.subtitle"), replacements), 10, 40, 10).send(player);
            }
            if (!AxSellwands.LANG.getString("sounds.inspect").isEmpty()) {
                player.playSound(player.getLocation(), Sound.valueOf((String)AxSellwands.LANG.getString("sounds.inspect")), 1.0f, 1.0f);
            }
            if (!AxSellwands.LANG.getString("particles.inspect").isEmpty()) {
                player.spawnParticle(Particle.valueOf((String)AxSellwands.LANG.getString("particles.inspect")), block.getLocation().add(0.5, 0.5, 0.5), 30, 0.5, 0.5, 0.5);
            }
        }
    }
}

