/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.listeners;

import com.artillexstudios.axsellwands.AxSellwands;
import com.artillexstudios.axsellwands.libs.axapi.items.NBTWrapper;
import com.artillexstudios.axsellwands.libs.axapi.utils.Cooldown;
import com.artillexstudios.axsellwands.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axsellwands.sellwands.Sellwand;
import com.artillexstudios.axsellwands.sellwands.Sellwands;
import com.artillexstudios.axsellwands.utils.NumberUtils;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;

public class InventoryClickListener
implements Listener {
    private final Cooldown<Player> cooldown = Cooldown.create();

    @EventHandler(ignoreCancelled=true)
    public void onClick(@NotNull InventoryClickEvent event) {
        if (AxSellwands.CONFIG.getInt("stacking-mode", 1) != 1) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        if (event.getClickedInventory() == null || !event.getClickedInventory().equals((Object)player.getInventory())) {
            return;
        }
        if (event.getCursor() == null || event.getCursor().getType() == Material.AIR) {
            return;
        }
        if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        NBTWrapper wrapperCurrent = new NBTWrapper(event.getCurrentItem());
        NBTWrapper wrapperCursor = new NBTWrapper(event.getCursor());
        String type1 = wrapperCurrent.getString("axsellwands-type");
        String type2 = wrapperCursor.getString("axsellwands-type");
        if (type1 == null || type2 == null) {
            return;
        }
        if (!type1.equals(type2)) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.cant-stack", new TagResolver[0]);
            return;
        }
        if (event.getCursor().getAmount() > 1 || event.getCurrentItem().getAmount() > 1) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.unstack-first", new TagResolver[0]);
            return;
        }
        int uses1 = wrapperCurrent.getIntOr("axsellwands-uses", -1);
        if (uses1 == -1) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.cant-stack", new TagResolver[0]);
            return;
        }
        UUID uuid1 = wrapperCurrent.getUUID("axsellwands-uuid");
        float multiplier1 = wrapperCurrent.getFloatOr("axsellwands-multiplier", 1.0f).floatValue();
        int maxUses1 = wrapperCurrent.getIntOr("axsellwands-max-uses", -1);
        int soldAmount1 = wrapperCurrent.getIntOr("axsellwands-sold-amount", 0);
        double soldPrice1 = wrapperCurrent.getDoubleOr("axsellwands-sold-price", 0.0);
        int uses2 = wrapperCursor.getIntOr("axsellwands-uses", -1);
        if (uses2 == -1) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.cant-stack", new TagResolver[0]);
            return;
        }
        event.setCancelled(true);
        if (!this.cooldown.hasCooldown(player)) {
            AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.confirm", new TagResolver[0]);
            this.cooldown.addCooldown(player, 3000L);
            return;
        }
        int maxUses2 = wrapperCursor.getIntOr("axsellwands-max-uses", -1);
        int soldAmount2 = wrapperCursor.getIntOr("axsellwands-sold-amount", 0);
        double soldPrice2 = wrapperCursor.getDoubleOr("axsellwands-sold-price", 0.0);
        int newMax = Math.max(maxUses1, maxUses2);
        int newUses = Math.min(AxSellwands.CONFIG.getBoolean("allow-going-over-limit", false) ? Integer.MAX_VALUE : newMax, uses1 + uses2);
        int newSoldAmount = soldAmount1 + soldAmount2;
        double newSoldPrice = soldPrice1 + soldPrice2;
        HashMap<String, String> replacements = new HashMap<String, String>();
        replacements.put("%multiplier%", "" + multiplier1);
        replacements.put("%uses%", String.valueOf(newUses == -1 ? AxSellwands.LANG.getString("unlimited", "\u221e") : Integer.valueOf(newUses)));
        replacements.put("%max-uses%", String.valueOf(newMax == -1 ? AxSellwands.LANG.getString("unlimited", "\u221e") : Integer.valueOf(newMax)));
        replacements.put("%sold-amount%", "" + newSoldAmount);
        replacements.put("%sold-price%", NumberUtils.formatNumber(newSoldPrice));
        Sellwand wand = Sellwands.getSellwands().get(type1);
        ItemBuilder builder = ItemBuilder.create(wand.getItemSection(), replacements);
        event.getCurrentItem().setItemMeta(builder.get().getItemMeta());
        NBTWrapper wrapper = new NBTWrapper(event.getCurrentItem());
        wrapper.set("axsellwands-uuid", uuid1);
        wrapper.set("axsellwands-uses", newUses);
        wrapper.set("axsellwands-max-uses", newMax);
        wrapper.set("axsellwands-sold-amount", newSoldAmount);
        wrapper.set("axsellwands-sold-price", newSoldPrice);
        wrapper.set("axsellwands-lastused", System.currentTimeMillis());
        wrapper.set("axsellwands-type", type1);
        wrapper.set("axsellwands-multiplier", multiplier1);
        wrapper.build();
        AxSellwands.MESSAGEUTILS.sendLang((CommandSender)player, "stack.success", new TagResolver[0]);
        event.getCursor().setAmount(0);
    }
}

