/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.utils;

import com.artillexstudios.axsellwands.libs.axapi.utils.Vector3f;

public final class Colors {
    public static int color(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static int color(int red, int green, int blue) {
        return Colors.color(255, red, green, blue);
    }

    public static int fromVector(Vector3f rgb) {
        return Colors.color(Colors.transform(rgb.x()), Colors.transform(rgb.y()), Colors.transform(rgb.z()));
    }

    public static int transform(float value) {
        return Colors.floor(value * 255.0f);
    }

    public static int floor(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static Vector3f toVector(int rgb) {
        float f = (float)Colors.red(rgb) / 255.0f;
        float g = (float)Colors.green(rgb) / 255.0f;
        float h = (float)Colors.blue(rgb) / 255.0f;
        return new Vector3f(f, g, h);
    }

    public static int red(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int green(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blue(int argb) {
        return argb & 0xFF;
    }
}

