/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.reflection;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FastMethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(FastMethodInvoker.class);

    public static FastMethodInvoker create(String clazz, String method, Class<?> ... parameters) {
        try {
            return FastMethodInvoker.create(Class.forName(clazz).getDeclaredMethod(method, parameters));
        }
        catch (Exception exception) {
            log.error("An unexpected error occurred while creating new FastMethodInvoker for class {}, method {}!", new Object[]{clazz, method, exception});
            throw new RuntimeException(exception);
        }
    }

    public static FastMethodInvoker create(Method method) {
        FastMethodInvoker invoker = null;
        method.setAccessible(true);
        if (method.getParameters().length == 0) {
            Class<?> returnType = method.getReturnType();
            invoker = returnType == Void.TYPE ? (Modifier.isStatic(method.getModifiers()) ? new FastStaticRunnableInvoker(method) : new FastInstanceRunnableInvoker(method)) : (Modifier.isStatic(method.getModifiers()) ? new FastStaticSupplierInvoker(method) : new FastInstanceSupplierInvoker(method));
        } else if (method.getParameters().length == 1) {
            invoker = method.getReturnType() != Void.TYPE ? (Modifier.isStatic(method.getModifiers()) ? new FastStaticFunctionInvoker(method) : new FastInstanceFunctionInvoker(method)) : (Modifier.isStatic(method.getModifiers()) ? new FastStaticBiSupplierInvoker(method) : new FastInstanceBiSupplierInvoker(method));
        } else if (method.getParameters().length == 2 && method.getReturnType() != Void.TYPE) {
            invoker = Modifier.isStatic(method.getModifiers()) ? new FastStaticBiFunctionInvoker(method) : new FastInstanceBiFunctionInvoker(method);
        }
        if (invoker == null) {
            invoker = new MethodHandleFallbackInvoker(method);
        }
        return invoker;
    }

    public abstract <T> T invoke(Object var1, Object ... var2);

    private static final class FastStaticRunnableInvoker
    extends FastMethodInvoker {
        Runnable runnable;

        private FastStaticRunnableInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "run", MethodType.methodType(Runnable.class, MethodHandle.class), MethodType.methodType(Void.TYPE), MethodHandles.exactInvoker(handle.type()), MethodType.methodType(Void.TYPE));
                this.runnable = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            this.runnable.run();
            return null;
        }
    }

    private static final class FastInstanceRunnableInvoker
    extends FastMethodInvoker {
        Consumer<Object> consumer;

        private FastInstanceRunnableInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "accept", MethodType.methodType(Consumer.class, MethodHandle.class), MethodType.methodType(Void.TYPE, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.consumer = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            this.consumer.accept(instance);
            return null;
        }
    }

    private static final class FastStaticSupplierInvoker
    extends FastMethodInvoker {
        Supplier<?> supplier;

        private FastStaticSupplierInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "get", MethodType.methodType(Supplier.class, MethodHandle.class), MethodType.methodType(Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.get();
        }
    }

    private static final class FastInstanceSupplierInvoker
    extends FastMethodInvoker {
        Function<Object, Object> supplier;

        private FastInstanceSupplierInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(Function.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.apply(instance);
        }
    }

    private static final class FastStaticFunctionInvoker
    extends FastMethodInvoker {
        Function<Object, Object> supplier;

        private FastStaticFunctionInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(Function.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.apply(a[0]);
        }
    }

    private static final class FastInstanceFunctionInvoker
    extends FastMethodInvoker {
        BiFunction<Object, Object, Object> supplier;

        private FastInstanceFunctionInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(BiFunction.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.apply(instance, a[0]);
        }
    }

    private static final class FastStaticBiSupplierInvoker
    extends FastMethodInvoker {
        Consumer<Object> supplier;

        private FastStaticBiSupplierInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "accept", MethodType.methodType(Consumer.class, MethodHandle.class), MethodType.methodType(Void.TYPE, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            this.supplier.accept(a[0]);
            return null;
        }
    }

    private static final class FastInstanceBiSupplierInvoker
    extends FastMethodInvoker {
        BiConsumer<Object, Object> supplier;

        private FastInstanceBiSupplierInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "accept", MethodType.methodType(BiConsumer.class, MethodHandle.class), MethodType.methodType(Void.TYPE, Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            this.supplier.accept(instance, a[0]);
            return null;
        }
    }

    private static final class FastStaticBiFunctionInvoker
    extends FastMethodInvoker {
        BiFunction<Object, Object, Object> supplier;

        private FastStaticBiFunctionInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(BiFunction.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.apply(a[0], a[1]);
        }
    }

    private static final class FastInstanceBiFunctionInvoker
    extends FastMethodInvoker {
        TriFunction<Object, Object, Object, Object> supplier;

        private FastInstanceBiFunctionInvoker(Method method) {
            try {
                MethodHandle handle = MethodHandles.lookup().unreflect(method);
                CallSite callSite = LambdaMetafactory.metafactory(MethodHandles.lookup(), "apply", MethodType.methodType(TriFunction.class, MethodHandle.class), MethodType.methodType(Object.class, Object.class, Object.class, Object.class), MethodHandles.exactInvoker(handle.type()), handle.type());
                this.supplier = callSite.getTarget().invokeExact(handle);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            return (T)this.supplier.apply(instance, a[0], a[1]);
        }
    }

    private static final class MethodHandleFallbackInvoker
    extends FastMethodInvoker {
        MethodHandle handle;

        private MethodHandleFallbackInvoker(Method method) {
            try {
                this.handle = MethodHandles.lookup().unreflect(method);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }

        @Override
        public <T> T invoke(Object instance, Object ... a) {
            try {
                return (T)this.handle.invoke(instance, a);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface TriFunction<A, B, C, D> {
        public A apply(B var1, C var2, D var3);
    }
}

