/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axsellwands.libs.axapi.gui.inventory.listener;

import com.artillexstudios.axsellwands.libs.axapi.gui.inventory.renderer.InventoryRenderer;
import com.artillexstudios.axsellwands.libs.axapi.items.WrappedItemStack;
import com.artillexstudios.axsellwands.libs.axapi.items.component.DataComponents;
import com.artillexstudios.axsellwands.libs.axapi.items.nbt.CompoundTag;
import com.artillexstudios.axsellwands.libs.axapi.utils.PaperUtils;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public final class InventoryClickListener
implements Listener {
    @EventHandler
    public void onInventoryClickEvent(InventoryClickEvent event) {
        InventoryHolder inventoryHolder;
        if (event.getCurrentItem() != null && event.getClickedInventory() != null && event.getClickedInventory().equals((Object)event.getView().getBottomInventory())) {
            this.checkAndRemove(event.getCurrentItem());
        }
        if (!((inventoryHolder = PaperUtils.getHolder(event.getInventory(), false)) instanceof InventoryRenderer)) {
            return;
        }
        InventoryRenderer renderer = (InventoryRenderer)inventoryHolder;
        renderer.handleClick(event);
    }

    @EventHandler
    public void onInventoryDragEvent(InventoryDragEvent event) {
        InventoryHolder inventoryHolder = PaperUtils.getHolder(event.getInventory(), false);
        if (!(inventoryHolder instanceof InventoryRenderer)) {
            return;
        }
        InventoryRenderer renderer = (InventoryRenderer)inventoryHolder;
        renderer.handleDrag(event);
    }

    @EventHandler
    public void onInventoryCloseEvent(InventoryCloseEvent event) {
        this.checkAndRemove(event.getPlayer().getInventory().getContents());
        InventoryHolder inventoryHolder = PaperUtils.getHolder(event.getInventory(), false);
        if (!(inventoryHolder instanceof InventoryRenderer)) {
            return;
        }
        InventoryRenderer renderer = (InventoryRenderer)inventoryHolder;
        renderer.handleClose(event);
    }

    @EventHandler
    public void onInventoryOpenEvent(InventoryOpenEvent event) {
        this.checkAndRemove(event.getPlayer().getInventory().getContents());
        InventoryHolder inventoryHolder = PaperUtils.getHolder(event.getInventory(), false);
        if (!(inventoryHolder instanceof InventoryRenderer)) {
            return;
        }
        InventoryRenderer renderer = (InventoryRenderer)inventoryHolder;
        renderer.handleOpen(event);
    }

    @EventHandler
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        this.checkAndRemove(event.getItemDrop().getItemStack());
    }

    @EventHandler
    public void onPlayerInteractEvent(PlayerInteractEvent event) {
        this.checkAndRemove(event.getItem());
    }

    private void checkAndRemove(ItemStack[] items) {
        for (ItemStack item : items) {
            this.checkAndRemove(item);
        }
    }

    private void checkAndRemove(ItemStack stack) {
        if (stack == null) {
            return;
        }
        WrappedItemStack wrapped = WrappedItemStack.wrap(stack);
        CompoundTag compoundTag = wrapped.get(DataComponents.customData());
        if (!compoundTag.contains("axapi-gui")) {
            return;
        }
        stack.setAmount(0);
    }
}

