/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.utils;

import com.artillexstudios.axrewards.AxRewards;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public class TimeUtils {
    @NotNull
    public static String fancyTime(long time) {
        if (time < 0L) {
            return "---";
        }
        Duration remainingTime = Duration.ofMillis(time);
        long total = remainingTime.getSeconds();
        long days = total / 86400L;
        long hours = total % 86400L / 3600L;
        long minutes = total % 3600L / 60L;
        long seconds = total % 60L;
        if (AxRewards.CONFIG.getInt("timer-format", 1) == 1) {
            if (days > 0L) {
                return String.format("%02d:%02d:%02d:%02d", days, hours, minutes, seconds);
            }
            if (hours > 0L) {
                return String.format("%02d:%02d:%02d", hours, minutes, seconds);
            }
            return String.format("%02d:%02d", minutes, seconds);
        }
        if (AxRewards.CONFIG.getInt("timer-format", 1) == 2) {
            if (days > 0L) {
                return days + AxRewards.LANG.getString("time.day", "d");
            }
            if (hours > 0L) {
                return hours + AxRewards.LANG.getString("time.hour", "h");
            }
            if (minutes > 0L) {
                return minutes + AxRewards.LANG.getString("time.minute", "m");
            }
            return seconds + AxRewards.LANG.getString("time.second", "s");
        }
        if (days > 0L) {
            return String.format("%02d" + AxRewards.LANG.getString("time.day", "d") + " %02d" + AxRewards.LANG.getString("time.hour", "h") + " %02d" + AxRewards.LANG.getString("time.minute", "m") + " %02d" + AxRewards.LANG.getString("time.second", "s"), days, hours, minutes, seconds);
        }
        if (hours > 0L) {
            return String.format("%02d" + AxRewards.LANG.getString("time.hour", "h") + " %02d" + AxRewards.LANG.getString("time.minute", "m") + " %02d" + AxRewards.LANG.getString("time.second", "s"), hours, minutes, seconds);
        }
        return String.format("%02d" + AxRewards.LANG.getString("time.minute", "m") + " %02d" + AxRewards.LANG.getString("time.second", "s"), minutes, seconds);
    }

    public static long timeFromString(@NotNull String time) {
        String[] tm = time.split("");
        long dateEnd = 0L;
        Object ch = "";
        String[] stringArray = tm;
        int n = stringArray.length;
        block16: for (int i = 0; i < n; ++i) {
            String txt;
            switch (txt = stringArray[i]) {
                case "s": {
                    dateEnd += TimeUtils.getInSeconds(Long.parseLong((String)ch));
                    ch = "";
                    continue block16;
                }
                case "m": {
                    dateEnd += TimeUtils.getInMinutes(Long.parseLong((String)ch));
                    ch = "";
                    continue block16;
                }
                case "h": {
                    dateEnd += TimeUtils.getInHours(Long.parseLong((String)ch));
                    ch = "";
                    continue block16;
                }
                case "d": {
                    dateEnd += TimeUtils.getInDays(Long.parseLong((String)ch));
                    ch = "";
                    continue block16;
                }
                case "w": {
                    dateEnd += TimeUtils.getInDays(Long.parseLong((String)ch) * 7L);
                    ch = "";
                    continue block16;
                }
                case "y": {
                    dateEnd += TimeUtils.getInDays(Long.parseLong((String)ch) * 365L);
                    ch = "";
                    continue block16;
                }
                default: {
                    ch = (String)ch + txt;
                }
            }
        }
        return dateEnd;
    }

    private static long getInDays(long time) {
        return time * 86400000L;
    }

    private static long getInHours(long time) {
        return time * 3600000L;
    }

    private static long getInMinutes(long time) {
        return time * 60000L;
    }

    private static long getInSeconds(long time) {
        return time * 1000L;
    }
}

