/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.lamp.bukkit.brigadier;

import com.artillexstudios.axrewards.libs.lamp.annotation.Range;
import com.artillexstudios.axrewards.libs.lamp.bukkit.Version;
import com.artillexstudios.axrewards.libs.lamp.bukkit.brigadier.ArgumentTypeResolver;
import com.artillexstudios.axrewards.libs.lamp.bukkit.brigadier.MinecraftArgumentType;
import com.artillexstudios.axrewards.libs.lamp.bukkit.core.BukkitHandler;
import com.artillexstudios.axrewards.libs.lamp.util.Preconditions;
import com.artillexstudios.axrewards.libs.lamp.util.Primitives;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public final class DefaultArgTypeResolvers {
    public static final ArgumentTypeResolver STRING = parameter -> {
        if (parameter.consumesAllString()) {
            return StringArgumentType.greedyString();
        }
        return StringArgumentType.string();
    };
    public static final ArgumentTypeResolver BOOLEAN = parameter -> BoolArgumentType.bool();
    public static final ArgumentTypeResolver NUMBER = parameter -> {
        @Nullable Range range = parameter.getAnnotation(Range.class);
        Class<?> type = Primitives.wrap(parameter.getType());
        if (type == Integer.class) {
            if (range == null) {
                return IntegerArgumentType.integer();
            }
            return IntegerArgumentType.integer((int)((int)range.min()), (int)((int)range.max()));
        }
        if (type == Double.class) {
            if (range == null) {
                return DoubleArgumentType.doubleArg();
            }
            return DoubleArgumentType.doubleArg((double)range.min(), (double)range.max());
        }
        if (type == Float.class) {
            if (range == null) {
                return FloatArgumentType.floatArg();
            }
            return FloatArgumentType.floatArg((float)((float)range.min()), (float)((float)range.max()));
        }
        if (type == Long.class) {
            if (range == null) {
                return LongArgumentType.longArg();
            }
            return LongArgumentType.longArg((long)((long)range.min()), (long)((long)range.max()));
        }
        if (type == Short.class) {
            if (range == null) {
                return IntegerArgumentType.integer((int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
            }
            return IntegerArgumentType.integer((int)Preconditions.coerceAtLeast((int)range.min(), Short.MIN_VALUE), (int)Preconditions.coerceAtMost((int)range.max(), Short.MAX_VALUE));
        }
        if (type == Byte.class) {
            if (range == null) {
                return IntegerArgumentType.integer((int)-128, (int)127);
            }
            return IntegerArgumentType.integer((int)Preconditions.coerceAtLeast((int)range.min(), -128), (int)Preconditions.coerceAtMost((int)range.max(), 127));
        }
        return null;
    };
    private static final ArgumentType<?> SINGLE_PLAYER = DefaultArgTypeResolvers.entity(true, true);
    private static final ArgumentType<?> MULTI_PLAYER = DefaultArgTypeResolvers.entity(false, true);
    private static final ArgumentType<?> MULTI_ENTITY = DefaultArgTypeResolvers.entity(false, false);
    public static final ArgumentTypeResolver PLAYER = parameter -> SINGLE_PLAYER;
    public static final ArgumentTypeResolver ENTITY_SELECTOR = parameter -> {
        Class<? extends Entity> type = BukkitHandler.getSelectedEntity(parameter.getFullType());
        if (Player.class.isAssignableFrom(type)) {
            return MULTI_PLAYER;
        }
        return MULTI_ENTITY;
    };

    private DefaultArgTypeResolvers() {
    }

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private static ArgumentType<?> entity(boolean single, boolean playerOnly) {
        return Version.getServerVersion() == Version.v1_21_8_PAPER ? MinecraftArgumentType.ENTITY_PAPER.create(single, playerOnly) : MinecraftArgumentType.ENTITY.create(single, playerOnly);
    }
}

