/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.gui.guis;

import com.artillexstudios.axrewards.libs.gui.components.GuiContainer;
import com.artillexstudios.axrewards.libs.gui.components.InteractionModifier;
import com.artillexstudios.axrewards.libs.gui.components.ScrollType;
import com.artillexstudios.axrewards.libs.gui.guis.GuiItem;
import com.artillexstudios.axrewards.libs.gui.guis.PaginatedGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.entity.HumanEntity;
import org.jetbrains.annotations.NotNull;

public class ScrollingGui
extends PaginatedGui {
    private final ScrollType scrollType;
    private int scrollSize = 0;

    public ScrollingGui(@NotNull GuiContainer guiContainer, int pageSize, @NotNull ScrollType scrollType, @NotNull Set<InteractionModifier> interactionModifiers) {
        super(guiContainer, pageSize, interactionModifiers);
        this.scrollType = scrollType;
    }

    @Override
    public boolean next() {
        if (this.getPageNum() * this.scrollSize + this.getPageSize() >= this.getPageItems().size() + this.scrollSize) {
            return false;
        }
        this.setPageNum(this.getPageNum() + 1);
        this.updatePage();
        return true;
    }

    @Override
    public boolean previous() {
        if (this.getPageNum() - 1 == 0) {
            return false;
        }
        this.setPageNum(this.getPageNum() - 1);
        this.updatePage();
        return true;
    }

    @Override
    public void open(@NotNull HumanEntity player) {
        this.open(player, 1);
    }

    @Override
    public void open(@NotNull HumanEntity player, int openPage) {
        if (player.isSleeping()) {
            return;
        }
        this.getInventory().clear();
        this.getMutableCurrentPageItems().clear();
        this.populateGui();
        if (this.getPageSize() == 0) {
            this.setPageSize(this.calculatePageSize());
        }
        if (this.scrollSize == 0) {
            this.scrollSize = this.calculateScrollSize();
        }
        if (openPage > 0 && openPage * this.scrollSize + this.getPageSize() <= this.getPageItems().size() + this.scrollSize) {
            this.setPageNum(openPage);
        }
        this.populatePage();
        player.openInventory(this.getInventory());
    }

    @Override
    void updatePage() {
        this.clearPage();
        this.populatePage();
    }

    private void populatePage() {
        for (GuiItem guiItem : this.getPage(this.getPageNum())) {
            if (this.scrollType == ScrollType.HORIZONTAL) {
                this.putItemHorizontally(guiItem);
                continue;
            }
            this.putItemVertically(guiItem);
        }
    }

    private int calculateScrollSize() {
        int counter = 0;
        if (this.scrollType == ScrollType.VERTICAL) {
            boolean foundCol = false;
            for (int row = 1; row <= this.getRows(); ++row) {
                for (int col = 1; col <= 9; ++col) {
                    int slot = this.getSlotFromRowCol(row, col);
                    if (this.getInventory().getItem(slot) != null) continue;
                    if (!foundCol) {
                        foundCol = true;
                    }
                    ++counter;
                }
                if (!foundCol) continue;
                return counter;
            }
            return counter;
        }
        boolean foundRow = false;
        for (int col = 1; col <= 9; ++col) {
            for (int row = 1; row <= this.getRows(); ++row) {
                int slot = this.getSlotFromRowCol(row, col);
                if (this.getInventory().getItem(slot) != null) continue;
                if (!foundRow) {
                    foundRow = true;
                }
                ++counter;
            }
            if (!foundRow) continue;
            return counter;
        }
        return counter;
    }

    private void putItemVertically(GuiItem guiItem) {
        for (int slot = 0; slot < this.getRows() * 9; ++slot) {
            if (this.getGuiItem(slot) != null || this.getInventory().getItem(slot) != null) continue;
            this.getMutableCurrentPageItems().put(slot, guiItem);
            this.getInventory().setItem(slot, guiItem.getItemStack());
            break;
        }
    }

    private void putItemHorizontally(GuiItem guiItem) {
        for (int col = 1; col < 10; ++col) {
            for (int row = 1; row <= this.getRows(); ++row) {
                int slot = this.getSlotFromRowCol(row, col);
                if (this.getGuiItem(slot) != null || this.getInventory().getItem(slot) != null) continue;
                this.getMutableCurrentPageItems().put(slot, guiItem);
                this.getInventory().setItem(slot, guiItem.getItemStack());
                return;
            }
        }
    }

    private List<GuiItem> getPage(int givenPage) {
        int page = givenPage - 1;
        int pageItemsSize = this.getPageItems().size();
        ArrayList<GuiItem> guiPage = new ArrayList<GuiItem>();
        int max = page * this.scrollSize + this.getPageSize();
        if (max > pageItemsSize) {
            max = pageItemsSize;
        }
        for (int i = page * this.scrollSize; i < max; ++i) {
            guiPage.add(this.getPageItems().get(i));
        }
        return guiPage;
    }
}

