/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.gui.builder.gui;

import com.artillexstudios.axrewards.libs.gui.builder.gui.BaseGuiBuilder;
import com.artillexstudios.axrewards.libs.gui.components.GuiContainer;
import com.artillexstudios.axrewards.libs.gui.components.InventoryProvider;
import com.artillexstudios.axrewards.libs.gui.components.util.Legacy;
import com.artillexstudios.axrewards.libs.gui.guis.BaseGui;
import org.bukkit.Bukkit;
import org.bukkit.inventory.InventoryHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class BaseChestGuiBuilder<G extends BaseGui, B extends BaseChestGuiBuilder<G, B>>
extends BaseGuiBuilder<G, B> {
    private int rows = 1;
    private InventoryProvider.Chest inventoryProvider = (title, owner, rows) -> Bukkit.createInventory((InventoryHolder)owner, (int)rows, (String)Legacy.SERIALIZER.serialize(title));

    @NotNull
    @Contract(value="_ -> this")
    public B rows(int rows) {
        this.rows = rows;
        return (B)this;
    }

    public B inventory(@NotNull InventoryProvider.Chest inventoryProvider) {
        this.inventoryProvider = inventoryProvider;
        return (B)this;
    }

    protected int getRows() {
        return this.rows;
    }

    @NotNull
    protected InventoryProvider.Chest getInventoryProvider() {
        return this.inventoryProvider;
    }

    @NotNull
    protected GuiContainer.Chest createContainer() {
        return new GuiContainer.Chest(this.getTitle(), this.inventoryProvider, this.getRows());
    }
}

