/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.packet.wrapper.clientbound;

import com.artillexstudios.axrewards.libs.axapi.packet.ClientboundPacketTypes;
import com.artillexstudios.axrewards.libs.axapi.packet.FriendlyByteBuf;
import com.artillexstudios.axrewards.libs.axapi.packet.PacketEvent;
import com.artillexstudios.axrewards.libs.axapi.packet.PacketType;
import com.artillexstudios.axrewards.libs.axapi.packet.wrapper.PacketWrapper;
import com.artillexstudios.axrewards.libs.axapi.packetentity.meta.Metadata;
import com.artillexstudios.axrewards.libs.axapi.packetentity.meta.serializer.EntityDataSerializer;
import com.artillexstudios.axrewards.libs.axapi.packetentity.meta.serializer.EntityDataSerializers;
import java.util.ArrayList;
import java.util.List;

public final class ClientboundEntityMetadataWrapper
extends PacketWrapper {
    private int entityId;
    private List<Metadata.DataItem<?>> items;

    public ClientboundEntityMetadataWrapper(PacketEvent event) {
        super(event);
    }

    public ClientboundEntityMetadataWrapper(int entityId, List<Metadata.DataItem<?>> items) {
        this.entityId = entityId;
        this.items = items;
    }

    public int entityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public List<Metadata.DataItem<?>> items() {
        return this.items;
    }

    public void setItems(List<Metadata.DataItem<?>> items) {
        this.items = items;
        this.markDirty();
    }

    @Override
    public void write(FriendlyByteBuf out) {
        out.writeVarInt(this.entityId);
        for (Metadata.DataItem<?> item : this.items) {
            int serializer = EntityDataSerializers.getId(item.serializer());
            out.writeByte(item.id());
            out.writeVarInt(serializer);
            item.serializer().write(out, item.getValue());
        }
        out.writeByte(255);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        short i;
        this.entityId = buf.readVarInt();
        this.items = new ArrayList();
        while ((i = buf.readUnsignedByte()) != 255) {
            int serializerId = buf.readVarInt();
            EntityDataSerializer serializer = EntityDataSerializers.byId(serializerId);
            this.items.add(new Metadata.DataItem(i, serializer, serializer.read(buf)));
        }
    }

    @Override
    public PacketType packetType() {
        return ClientboundPacketTypes.SET_ENTITY_DATA;
    }
}

