/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.nms.v1_21_R1.items;

import com.artillexstudios.axrewards.libs.axapi.items.HashGenerator;
import com.artillexstudios.axrewards.libs.axapi.items.HashedStack;
import com.artillexstudios.axrewards.libs.axapi.items.component.DataComponent;
import com.artillexstudios.axrewards.libs.axapi.nms.v1_21_R1.ItemStackSerializer;
import com.artillexstudios.axrewards.libs.axapi.reflection.FieldAccessor;
import java.util.Objects;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class WrappedItemStack
implements com.artillexstudios.axrewards.libs.axapi.items.WrappedItemStack {
    private static final FieldAccessor handleAccessor = FieldAccessor.builder().withClass(CraftItemStack.class).withField("handle").build();
    public net.minecraft.world.item.ItemStack itemStack;
    private ItemStack bukkitStack;
    private boolean dirty;

    public WrappedItemStack(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack itemStack2;
        if (itemStack.getType().isAir()) {
            itemStack2 = net.minecraft.world.item.ItemStack.l;
        } else if (itemStack instanceof CraftItemStack) {
            CraftItemStack cr = (CraftItemStack)itemStack;
            itemStack2 = handleAccessor.get(cr, net.minecraft.world.item.ItemStack.class);
        } else {
            itemStack2 = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        }
        this(itemStack2);
        this.bukkitStack = itemStack;
    }

    public WrappedItemStack(net.minecraft.world.item.ItemStack itemStack) {
        this.dirty = false;
        this.itemStack = itemStack;
        this.bukkitStack = null;
    }

    @Override
    public <T> void set(DataComponent<T> component, T value) {
        this.dirty = true;
        component.apply(this.itemStack, value);
    }

    @Override
    public <T> T get(DataComponent<T> component) {
        return component.get(this.itemStack);
    }

    @Override
    public int getAmount() {
        return this.itemStack.H();
    }

    @Override
    public void setAmount(int amount) {
        this.itemStack.e(amount);
    }

    @Override
    public ItemStack toBukkit() {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)this.itemStack);
    }

    @Override
    public HashedStack toHashedStack(HashGenerator hashGenerator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toSNBT() {
        return ItemStackSerializer.INSTANCE.serializeAsSnbt(this.toBukkit());
    }

    @Override
    public byte[] serialize() {
        return ItemStackSerializer.INSTANCE.serializeAsBytes(this.toBukkit());
    }

    @Override
    public void finishEdit() {
        if (!this.dirty) {
            return;
        }
        ItemMeta meta = CraftItemStack.getItemMeta((net.minecraft.world.item.ItemStack)this.itemStack);
        if (this.bukkitStack != null) {
            this.bukkitStack.setItemMeta(meta);
        } else {
            CraftItemStack.setItemMeta((net.minecraft.world.item.ItemStack)this.itemStack, (ItemMeta)meta);
        }
    }

    @Override
    public WrappedItemStack copy() {
        this.finishEdit();
        return new WrappedItemStack(this.itemStack.s());
    }

    @Override
    public void editFrom(com.artillexstudios.axrewards.libs.axapi.items.WrappedItemStack stack) {
        this.itemStack = ((WrappedItemStack)stack).itemStack;
        this.bukkitStack = ((WrappedItemStack)stack).bukkitStack;
    }

    @Override
    public void update(boolean force) {
    }

    @Override
    public ItemStack wrapped() {
        return this.toBukkit();
    }

    public net.minecraft.world.item.ItemStack asMinecraft() {
        return this.itemStack;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof WrappedItemStack)) {
            return false;
        }
        WrappedItemStack that = (WrappedItemStack)object;
        return Objects.equals(this.itemStack, that.itemStack) && Objects.equals(this.bukkitStack, that.bukkitStack);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.itemStack);
        result = 31 * result + Objects.hashCode(this.bukkitStack);
        return result;
    }
}

