/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.nms.v1_20_R1.items.nbt;

import com.artillexstudios.axrewards.libs.axapi.items.nbt.Tag;
import com.artillexstudios.axrewards.libs.axapi.nms.v1_20_R1.items.nbt.ListTag;
import com.artillexstudios.axrewards.libs.axapi.reflection.FieldAccessor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagType;

public class CompoundTag
implements com.artillexstudios.axrewards.libs.axapi.items.nbt.CompoundTag {
    private static final FieldAccessor accessor = FieldAccessor.builder().withClass(NBTTagCompound.class).withField("x").build();
    private final NBTTagCompound parent;
    private final Map<String, NBTBase> tags;

    public CompoundTag(NBTTagCompound tag) {
        this.parent = tag;
        this.tags = (Map)accessor.getUnchecked(tag);
    }

    @Override
    public void put(String key, Tag tag) {
        NBTTagList nBTTagList;
        Object object = tag.getParent();
        if (object instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)object;
            nBTTagList = compoundTag;
        } else {
            nBTTagList = (NBTTagList)tag.getParent();
        }
        this.parent.a(key, (NBTBase)nBTTagList);
    }

    @Override
    public void putByte(String key, byte value) {
        this.parent.a(key, value);
    }

    @Override
    public void putShort(String key, short value) {
        this.parent.a(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        this.parent.a(key, value);
    }

    @Override
    public void putLong(String key, long value) {
        this.parent.a(key, value);
    }

    @Override
    public void putUUID(String key, UUID value) {
        if (this.parent.e(key + "Most") && this.parent.e(key + "Least")) {
            this.parent.r(key + "Most");
            this.parent.r(key + "Least");
        }
        this.putIntArray(key, CompoundTag.uuidToIntArray(value));
    }

    @Override
    public UUID getUUID(String key) {
        return this.contains(key + "Most") && this.contains(key + "Least") ? new UUID(this.getLong(key + "Most"), this.getLong(key + "Least")) : (this.contains(key) ? CompoundTag.uuidFromIntArray(this.getIntArray(key)) : null);
    }

    @Override
    public boolean containsUUID(String key) {
        return this.contains(key + "Least") && this.contains(key + "Most") || this.contains(key);
    }

    @Override
    public void putFloat(String key, float value) {
        this.parent.a(key, value);
    }

    @Override
    public void putDouble(String key, double value) {
        this.parent.a(key, value);
    }

    @Override
    public void putString(String key, String value) {
        this.parent.a(key, value);
    }

    @Override
    public void putByteArray(String key, byte[] value) {
        this.parent.a(key, value);
    }

    @Override
    public void putByteArray(String key, List<Byte> value) {
        byte[] bytes = new byte[value.size()];
        int i = 0;
        for (Byte b2 : value) {
            bytes[i] = b2;
            ++i;
        }
        this.parent.a(key, bytes);
    }

    @Override
    public void putIntArray(String key, int[] value) {
        this.parent.a(key, value);
    }

    @Override
    public void putIntArray(String key, List<Integer> value) {
        int[] ints = new int[value.size()];
        int i = 0;
        for (Integer integer : value) {
            ints[i] = integer;
            ++i;
        }
        this.parent.a(key, ints);
    }

    @Override
    public void putLongArray(String key, long[] value) {
        this.parent.a(key, value);
    }

    @Override
    public void putLongArray(String key, List<Long> value) {
        long[] longs = new long[value.size()];
        int i = 0;
        for (Long l : value) {
            longs[i] = l;
            ++i;
        }
        this.parent.a(key, longs);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.parent.a(key, value);
    }

    @Override
    public boolean contains(String key) {
        return this.parent.e(key);
    }

    @Override
    public Byte getByte(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return ((NBTNumber)this.tags.get(key)).i();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Short getShort(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return ((NBTNumber)this.tags.get(key)).h();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Integer getInt(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return ((NBTNumber)this.tags.get(key)).g();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Long getLong(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return ((NBTNumber)this.tags.get(key)).f();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Float getFloat(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return Float.valueOf(((NBTNumber)this.tags.get(key)).k());
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Double getDouble(String key) {
        try {
            if (this.parent.b(key, 99)) {
                return ((NBTNumber)this.tags.get(key)).j();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getString(String key) {
        try {
            if (this.parent.b(key, 8)) {
                return this.tags.get(key).m_();
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public byte[] getByteArray(String key) {
        try {
            if (this.parent.b(key, 7)) {
                return ((NBTTagByteArray)this.tags.get(key)).e();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createReport(key, NBTTagByteArray.a, var3));
        }
        return null;
    }

    @Override
    public int[] getIntArray(String key) {
        try {
            if (this.parent.b(key, 11)) {
                return ((NBTTagIntArray)this.tags.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createReport(key, NBTTagIntArray.a, var3));
        }
        return null;
    }

    @Override
    public long[] getLongArray(String key) {
        try {
            if (this.parent.b(key, 12)) {
                return ((NBTTagLongArray)this.tags.get(key)).g();
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createReport(key, NBTTagLongArray.a, var3));
        }
        return null;
    }

    @Override
    public CompoundTag getCompound(String key) {
        try {
            if (this.parent.b(key, 10)) {
                return new CompoundTag((NBTTagCompound)this.tags.get(key));
            }
        }
        catch (ClassCastException var3) {
            throw new ReportedException(this.createReport(key, NBTTagCompound.b, var3));
        }
        return null;
    }

    @Override
    public ListTag getList(String key) {
        try {
            if (this.parent.d(key) == 9) {
                NBTTagList listTag = (NBTTagList)this.tags.get(key);
                if (!listTag.isEmpty() && listTag.f() != 10) {
                    return null;
                }
                return new ListTag(listTag);
            }
        }
        catch (ClassCastException var4) {
            throw new ReportedException(this.createReport(key, NBTTagList.a, var4));
        }
        return null;
    }

    @Override
    public Boolean getBoolean(String key) {
        Byte value = this.getByte(key);
        return value == null ? null : Boolean.valueOf(value != 0);
    }

    @Override
    public void remove(String key) {
        this.parent.r(key);
    }

    @Override
    public boolean isEmpty() {
        return this.parent.g();
    }

    @Override
    public Set<String> getAllKeys() {
        return this.parent.e();
    }

    public NBTTagCompound getParent() {
        return this.parent;
    }

    public static UUID uuidFromIntArray(int[] array) {
        return new UUID((long)array[0] << 32 | (long)array[1] & 0xFFFFFFFFL, (long)array[2] << 32 | (long)array[3] & 0xFFFFFFFFL);
    }

    public static int[] uuidToIntArray(UUID uuid) {
        long l = uuid.getMostSignificantBits();
        long m = uuid.getLeastSignificantBits();
        return CompoundTag.leastMostToIntArray(l, m);
    }

    private static int[] leastMostToIntArray(long uuidMost, long uuidLeast) {
        return new int[]{(int)(uuidMost >> 32), (int)uuidMost, (int)(uuidLeast >> 32), (int)uuidLeast};
    }

    private CrashReport createReport(String tagName, NBTTagType<?> type, ClassCastException exception) {
        CrashReport crashReport = CrashReport.a((Throwable)exception, (String)"Reading NBT data");
        CrashReportSystemDetails crashReportCategory = crashReport.a("Corrupt NBT tag", 1);
        crashReportCategory.a("Tag type found", () -> this.tags.get(tagName).c().a());
        Objects.requireNonNull(type);
        crashReportCategory.a("Tag type expected", () -> type.a());
        crashReportCategory.a("Tag name", (Object)tagName);
        return crashReport;
    }
}

