/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.config.adapters.primitive;

import com.artillexstudios.axrewards.libs.axapi.config.adapters.TypeAdapter;
import com.artillexstudios.axrewards.libs.axapi.config.adapters.TypeAdapterHolder;
import java.lang.reflect.Type;
import java.math.BigInteger;

public final class ByteAdapter
implements TypeAdapter<Byte, Byte> {
    @Override
    public Byte deserialize(TypeAdapterHolder registry, Object input, Type type) {
        if (input instanceof Number) {
            Number num = (Number)input;
            return this.validate(num);
        }
        if (input instanceof String) {
            String str = (String)input;
            return this.validate(Double.parseDouble(str));
        }
        throw new IllegalArgumentException("Can't make a byte from a " + String.valueOf(input.getClass()));
    }

    private Byte validate(Number number) {
        long longValue;
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            v0 = bigInteger.longValueExact();
        } else {
            v0 = longValue = number.longValue();
        }
        if (longValue > 127L || longValue < -128L) {
            throw new IllegalArgumentException("Byte value is not actually a byte! Should be between %s and %s, but was %s".formatted((byte)-128, (byte)127, longValue));
        }
        return (byte)longValue;
    }

    @Override
    public Byte serialize(TypeAdapterHolder registry, Byte value, Type type) {
        return value;
    }
}

