/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.guis.impl;

import com.artillexstudios.axrewards.AxRewards;
import com.artillexstudios.axrewards.guis.GuiFrame;
import com.artillexstudios.axrewards.guis.data.Menu;
import com.artillexstudios.axrewards.guis.data.MenuManager;
import com.artillexstudios.axrewards.guis.data.Reward;
import com.artillexstudios.axrewards.libs.axapi.nms.NMSHandlers;
import com.artillexstudios.axrewards.libs.axapi.scheduler.Scheduler;
import com.artillexstudios.axrewards.libs.axapi.utils.ContainerUtils;
import com.artillexstudios.axrewards.libs.axapi.utils.ItemBuilder;
import com.artillexstudios.axrewards.libs.axapi.utils.StringUtils;
import com.artillexstudios.axrewards.libs.gui.builder.gui.BaseGuiBuilder;
import com.artillexstudios.axrewards.libs.gui.builder.gui.TypedGuiBuilder;
import com.artillexstudios.axrewards.libs.gui.components.GuiType;
import com.artillexstudios.axrewards.libs.gui.guis.BaseGui;
import com.artillexstudios.axrewards.libs.gui.guis.Gui;
import com.artillexstudios.axrewards.utils.SoundUtils;
import com.artillexstudios.axrewards.utils.TimeUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class RewardGui
extends GuiFrame {
    private static final Set<RewardGui> openMenus = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final BaseGui gui;
    private final Player player;
    private final Menu menu;

    public RewardGui(Player player, Menu menu) {
        super(menu.settings(), player);
        this.player = player;
        this.menu = menu;
        GuiType guiType = GuiType.valueOf(this.file.getString("type", "CHEST"));
        TypedGuiBuilder builder = guiType == GuiType.CHEST ? Gui.gui().rows(this.file.getInt("rows", 6)) : Gui.gui(guiType);
        this.gui = ((BaseGuiBuilder)((BaseGuiBuilder)builder.disableAllInteractions()).title((Component)Component.empty())).create();
        this.gui.updateTitle(StringUtils.format(AxRewards.getPlaceholderParser().setPlaceholders((OfflinePlayer)player, this.file.getString("title")), new TagResolver[0]));
        this.setGui(this.gui);
    }

    public void open() {
        CompletableFuture cf = new CompletableFuture();
        AxRewards.getThreadedQueue().submit(() -> {
            if (this.file.getSection("close") != null) {
                super.createItem("close", "close", event -> Scheduler.get().runAt(this.player.getLocation(), scheduledTask -> this.player.closeInventory()));
            }
            for (Reward reward : this.menu.rewards()) {
                String permission = reward.claimPermission();
                if (permission != null && !this.player.hasPermission(permission)) {
                    Map<String, String> replacements = Map.of("%permission%", permission);
                    super.createItem(reward.name() + ".no-permission", reward.name(), event -> {
                        SoundUtils.playSound(this.player, AxRewards.LANG.getSection("no-permission"));
                        AxRewards.MESSAGEUTILS.sendLang((CommandSender)this.player, "no-permission.message", replacements);
                    }, replacements);
                    continue;
                }
                long lastClaim = AxRewards.getDatabase().getLastClaim((OfflinePlayer)this.player, reward);
                if (!MenuManager.canClaimReward(reward, lastClaim)) {
                    long next = lastClaim - System.currentTimeMillis() + reward.cooldown();
                    Map<String, String> replacements = Map.of("%time%", TimeUtils.fancyTime(next));
                    super.createItem(reward.name() + ".unclaimable", reward.name(), event -> {
                        SoundUtils.playSound(this.player, AxRewards.LANG.getSection("on-cooldown"));
                        if (next < 0L) {
                            AxRewards.MESSAGEUTILS.sendLang((CommandSender)this.player, "on-cooldown.one-time", replacements);
                        } else {
                            AxRewards.MESSAGEUTILS.sendLang((CommandSender)this.player, "on-cooldown.message", replacements);
                        }
                    }, replacements);
                    continue;
                }
                super.createItem(reward.name() + ".claimable", reward.name(), event -> {
                    long lastClaim2 = AxRewards.getDatabase().getLastClaim((OfflinePlayer)this.player, reward);
                    if (!MenuManager.canClaimReward(reward, lastClaim2)) {
                        this.open();
                        return;
                    }
                    if (permission != null && !this.player.hasPermission(permission)) {
                        SoundUtils.playSound(this.player, AxRewards.LANG.getSection("no-permission"));
                        AxRewards.MESSAGEUTILS.sendLang((CommandSender)this.player, "no-permission.message", Map.of("%permission%", permission));
                        return;
                    }
                    SoundUtils.playSound(this.player, AxRewards.LANG.getSection("claimed"));
                    AxRewards.MESSAGEUTILS.sendLang((CommandSender)this.player, "claimed.message", new TagResolver[0]);
                    AxRewards.getDatabase().claimReward((OfflinePlayer)this.player, reward);
                    Scheduler.get().run(scheduledTask -> {
                        for (String string : reward.claimCommands()) {
                            String string2 = string.replace("%player%", this.player.getName());
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)AxRewards.getPlaceholderParser().setPlaceholders((OfflinePlayer)this.player, string2));
                        }
                        for (Map map : reward.claimItems()) {
                            ItemStack it = ItemBuilder.create(map).get();
                            ContainerUtils.INSTANCE.addOrDrop((Inventory)this.player.getInventory(), List.of(it), this.player.getLocation());
                        }
                    });
                    this.open();
                });
            }
            cf.complete(null);
        });
        cf.thenRun(() -> {
            if (openMenus.contains(this)) {
                this.gui.update();
                this.updateTitle();
                return;
            }
            this.gui.setCloseGuiAction(e -> openMenus.remove(this));
            Scheduler.get().run(t -> {
                this.gui.open((HumanEntity)this.player);
                openMenus.add(this);
            });
        });
    }

    public void updateTitle() {
        if (!AxRewards.CONFIG.getBoolean("update-gui-title", false)) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null) {
            return;
        }
        Component title = StringUtils.format(AxRewards.getPlaceholderParser().setPlaceholders((OfflinePlayer)this.player, this.file.getString("title")), new TagResolver[0]);
        Inventory topInv = this.player.getPlayer().getOpenInventory().getTopInventory();
        if (topInv.equals((Object)this.gui.getInventory())) {
            NMSHandlers.getNmsHandler().setTitle(this.player.getPlayer().getOpenInventory().getTopInventory(), title);
        }
    }

    public BaseGui getGui() {
        return this.gui;
    }

    public Player getPlayer() {
        return this.player;
    }

    public static Set<RewardGui> getOpenMenus() {
        return openMenus;
    }
}

