/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.database.impl;

import com.artillexstudios.axrewards.AxRewards;
import com.artillexstudios.axrewards.database.impl.Base;
import com.artillexstudios.axrewards.libs.hikari.HikariConfig;
import com.artillexstudios.axrewards.libs.hikari.HikariDataSource;
import java.sql.Connection;

public class MySQL
extends Base {
    private final HikariConfig hConfig = new HikariConfig();
    private HikariDataSource dataSource;

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public String getType() {
        return "MySQL";
    }

    @Override
    public void setup() {
        this.hConfig.setPoolName("axrewards-pool");
        this.hConfig.setMaximumPoolSize(AxRewards.CONFIG.getInt("database.pool.maximum-pool-size"));
        this.hConfig.setMinimumIdle(AxRewards.CONFIG.getInt("database.pool.minimum-idle"));
        this.hConfig.setMaxLifetime((long)AxRewards.CONFIG.getInt("database.pool.maximum-lifetime"));
        this.hConfig.setKeepaliveTime((long)AxRewards.CONFIG.getInt("database.pool.keepalive-time"));
        this.hConfig.setConnectionTimeout((long)AxRewards.CONFIG.getInt("database.pool.connection-timeout"));
        this.hConfig.setDriverClassName("com.artillexstudios.axrewards.libs.mysql.cj.jdbc.Driver");
        this.hConfig.setJdbcUrl("jdbc:mysql://" + AxRewards.CONFIG.getString("database.address") + ":" + AxRewards.CONFIG.getString("database.port") + "/" + AxRewards.CONFIG.getString("database.database"));
        this.hConfig.addDataSourceProperty("user", (Object)AxRewards.CONFIG.getString("database.username"));
        this.hConfig.addDataSourceProperty("password", (Object)AxRewards.CONFIG.getString("database.password"));
        this.dataSource = new HikariDataSource(this.hConfig);
        super.setup();
    }

    @Override
    public void disable() {
        try {
            this.dataSource.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

