/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.commands;

import com.artillexstudios.axrewards.AxRewards;
import com.artillexstudios.axrewards.commands.Commands;
import com.artillexstudios.axrewards.commands.OpenCommand;
import com.artillexstudios.axrewards.guis.data.Menu;
import com.artillexstudios.axrewards.guis.data.MenuManager;
import com.artillexstudios.axrewards.guis.data.Reward;
import com.artillexstudios.axrewards.libs.axapi.config.Config;
import com.artillexstudios.axrewards.libs.axapi.utils.StringUtils;
import com.artillexstudios.axrewards.libs.lamp.bukkit.BukkitCommandHandler;
import com.artillexstudios.axrewards.libs.lamp.core.CommandPath;
import com.artillexstudios.axrewards.libs.lamp.exception.CommandErrorException;
import com.artillexstudios.axrewards.libs.lamp.orphan.OrphanRegistry;
import com.artillexstudios.axrewards.libs.lamp.orphan.Orphans;
import com.artillexstudios.axrewards.utils.CommandMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class CommandManager {
    private static BukkitCommandHandler handler = null;
    private static final List<CommandPath> registered = new ArrayList<CommandPath>();

    public static void load() {
        handler = BukkitCommandHandler.create((Plugin)AxRewards.getInstance());
        handler.getAutoCompleter().registerSuggestion("rewards", (args, sender, command) -> {
            String menu = (String)args.get(args.size() - 2);
            Config cfg = MenuManager.getMenus().get(menu).settings();
            if (cfg == null) {
                return List.of();
            }
            return cfg.getBackingDocument().getRoutesAsStrings(false).stream().filter(string -> cfg.getSection((String)string) != null).toList();
        });
        handler.getAutoCompleter().registerSuggestion("menus", (args, sender, command) -> MenuManager.getMenus().keySet());
        handler.registerValueResolver(Menu.class, resolver -> {
            String str = resolver.popForParameter();
            Menu menu = MenuManager.getMenus().get(str);
            if (menu != null) {
                return menu;
            }
            throw new CommandErrorException("Can't find menu!", new Object[0]);
        });
        handler.registerValueResolver(Reward.class, resolver -> {
            String str = resolver.popForParameter();
            String[] spl = str.split("-");
            String last = spl[0];
            str = str.replace(last + "-", "");
            Menu menu = MenuManager.getMenus().get(last);
            if (menu == null) {
                throw new CommandErrorException("Can't find reward!", new Object[0]);
            }
            String finalStr = str;
            Optional<Reward> reward = menu.rewards().stream().filter(rw -> rw.name().equals(finalStr)).findAny();
            if (reward.isPresent()) {
                return reward.get();
            }
            throw new CommandErrorException("Can't find reward!", new Object[0]);
        });
        handler.getAutoCompleter().registerParameterSuggestions(Menu.class, (args, sender, command) -> MenuManager.getMenus().keySet());
        handler.getAutoCompleter().registerParameterSuggestions(Reward.class, (args, sender, command) -> {
            String last = (String)args.get(args.size() - 2);
            Menu menu = MenuManager.getMenus().get(last);
            if (menu == null) {
                return List.of();
            }
            return menu.rewards().stream().map(reward -> menu.name() + "-" + reward.name()).toList();
        });
        handler.getTranslator().add(new CommandMessages());
        handler.setLocale(Locale.of("en", "US"));
        handler.register(Orphans.path((String[])AxRewards.CONFIG.getStringList("command-aliases").toArray(String[]::new)).handler(new Commands()));
        handler.registerBrigadier();
        CommandManager.reload();
    }

    public static void reload() {
        for (CommandPath commandPath : registered) {
            handler.unregister(commandPath);
        }
        registered.clear();
        for (Map.Entry entry : MenuManager.getMenus().entrySet()) {
            try {
                OrphanRegistry registry = Orphans.path((String[])((Menu)entry.getValue()).settings().getStringList("open-commands").toArray(String[]::new)).handler(new OpenCommand((Menu)entry.getValue()));
                registered.addAll(registry.getParentPaths());
                handler.register(registry);
            }
            catch (Exception ex) {
                Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FF0000[AxRewards] Failed to register the command of menu " + (String)entry.getKey() + ", one of the open-commands is already used by another menu/plugin!", new TagResolver[0]));
            }
        }
    }
}

