/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards;

import com.artillexstudios.axrewards.Converter2;
import com.artillexstudios.axrewards.commands.CommandManager;
import com.artillexstudios.axrewards.database.Database;
import com.artillexstudios.axrewards.database.impl.H2;
import com.artillexstudios.axrewards.database.impl.MySQL;
import com.artillexstudios.axrewards.database.impl.PostgreSQL;
import com.artillexstudios.axrewards.guis.GuiUpdater;
import com.artillexstudios.axrewards.guis.data.MenuManager;
import com.artillexstudios.axrewards.hooks.PlaceholderAPIHook;
import com.artillexstudios.axrewards.hooks.PlaceholderAPIParser;
import com.artillexstudios.axrewards.hooks.Placeholders;
import com.artillexstudios.axrewards.libraries.Libraries;
import com.artillexstudios.axrewards.libs.axapi.AxPlugin;
import com.artillexstudios.axrewards.libs.axapi.config.Config;
import com.artillexstudios.axrewards.libs.axapi.dependencies.DependencyManagerWrapper;
import com.artillexstudios.axrewards.libs.axapi.executor.ThreadedQueue;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.dvs.versioning.BasicVersioning;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.settings.dumper.DumperSettings;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.settings.general.GeneralSettings;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.settings.loader.LoaderSettings;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.settings.updater.UpdaterSettings;
import com.artillexstudios.axrewards.libs.axapi.metrics.AxMetrics;
import com.artillexstudios.axrewards.libs.axapi.utils.MessageUtils;
import com.artillexstudios.axrewards.libs.axapi.utils.StringUtils;
import com.artillexstudios.axrewards.libs.axapi.utils.featureflags.FeatureFlags;
import com.artillexstudios.axrewards.libs.bstats.bukkit.Metrics;
import com.artillexstudios.axrewards.utils.FileUtils;
import com.artillexstudios.axrewards.utils.UpdateNotifier;
import java.io.File;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import revxrsal.zapper.DependencyManager;
import revxrsal.zapper.relocation.Relocation;

public final class AxRewards
extends AxPlugin {
    public static Config CONFIG;
    public static Config LANG;
    public static MessageUtils MESSAGEUTILS;
    private static AxPlugin instance;
    private static ThreadedQueue<Runnable> threadedQueue;
    private static Database database;
    private static Placeholders placeholderParser;
    private static AxMetrics metrics;

    public static ThreadedQueue<Runnable> getThreadedQueue() {
        return threadedQueue;
    }

    public static Database getDatabase() {
        return database;
    }

    public static AxPlugin getInstance() {
        return instance;
    }

    public static Placeholders getPlaceholderParser() {
        return placeholderParser;
    }

    @Override
    public void dependencies(DependencyManagerWrapper manager) {
        instance = this;
        manager.repository("https://jitpack.io/");
        manager.repository("https://repo.codemc.org/repository/maven-public/");
        manager.repository("https://repo.papermc.io/repository/maven-public/");
        manager.repository("https://repo.artillex-studios.com/releases/");
        DependencyManager dependencyManager = manager.wrapped();
        for (Libraries lib : Libraries.values()) {
            dependencyManager.dependency(lib.fetchLibrary());
            for (Relocation relocation : lib.relocations()) {
                dependencyManager.relocate(relocation);
            }
        }
    }

    @Override
    public void enable() {
        new Metrics(this, 21023);
        CONFIG = new Config(new File(this.getDataFolder(), "config.yml"), this.getResource("config.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        LANG = new Config(new File(this.getDataFolder(), "lang.yml"), this.getResource("lang.yml"), GeneralSettings.builder().setUseDefaults(false).build(), LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT, UpdaterSettings.builder().setKeepAll(true).setVersioning(new BasicVersioning("version")).build());
        MESSAGEUTILS = new MessageUtils(LANG.getBackingDocument(), "prefix", CONFIG.getBackingDocument());
        threadedQueue = new ThreadedQueue("AxRewards-Datastore-thread");
        if (FileUtils.PLUGIN_DIRECTORY.resolve("menus/").toFile().mkdirs()) {
            if (new File(this.getDataFolder(), "guis.yml").exists()) {
                new Converter2();
            } else {
                FileUtils.copyFromResource("menus");
            }
        }
        MenuManager.reload();
        switch (CONFIG.getString("database.type").toLowerCase()) {
            case "mysql": {
                database = new MySQL();
                break;
            }
            case "postgresql": {
                database = new PostgreSQL();
                break;
            }
            default: {
                database = new H2();
            }
        }
        database.setup();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderAPIHook().register();
            placeholderParser = new PlaceholderAPIParser();
            Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FFEE00[AxRewards] Hooked into PlaceholderAPI!", new TagResolver[0]));
        } else {
            placeholderParser = new Placeholders(this){};
        }
        GuiUpdater.start();
        CommandManager.load();
        metrics = new AxMetrics(this, 42L);
        metrics.start();
        Bukkit.getConsoleSender().sendMessage(StringUtils.formatToString("&#FFEE00[AxRewards] Loaded plugin! Using &f" + database.getType() + " &#FFEE00database to store data!", new TagResolver[0]));
        if (CONFIG.getBoolean("update-notifier.enabled", true)) {
            new UpdateNotifier(this, 5549);
        }
    }

    @Override
    public void disable() {
        if (metrics != null) {
            metrics.cancel();
        }
        GuiUpdater.stop();
        database.disable();
    }

    @Override
    public void updateFlags() {
        FeatureFlags.USE_LEGACY_HEX_FORMATTER.set(true);
    }
}

