/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.utils;

import com.artillexstudios.axrewards.AxRewards;
import com.artillexstudios.axrewards.libs.axapi.libs.boostedyaml.block.implementation.Section;
import com.artillexstudios.axrewards.libs.axapi.utils.ItemBuilder;
import java.util.List;
import java.util.Map;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemBuilderUtil {
    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section) {
        return ItemBuilderUtil.newBuilder(player, section, Map.of());
    }

    @NotNull
    public static ItemBuilder newBuilder(@Nullable Player player, @NotNull Section section, Map<String, String> replacements) {
        ItemBuilder builder = ItemBuilder.create(section);
        section.getOptionalString("name").ifPresent(name -> {
            name = AxRewards.getPlaceholderParser().setPlaceholders((OfflinePlayer)player, (String)name);
            builder.setName((String)name, replacements);
        });
        section.getOptionalStringList("lore").ifPresent(lore -> {
            lore = AxRewards.getPlaceholderParser().setPlaceholders((OfflinePlayer)player, (List<String>)lore);
            builder.setLore((List<String>)lore, replacements);
        });
        return builder;
    }

    @NotNull
    @Contract(value="_ -> new")
    public static ItemBuilder newBuilder(@NotNull ItemStack itemStack) {
        return ItemBuilder.create(itemStack);
    }
}

