/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.lamp.core;

import com.artillexstudios.axrewards.libs.lamp.CommandHandler;
import com.artillexstudios.axrewards.libs.lamp.CommandHandlerVisitor;
import com.artillexstudios.axrewards.libs.lamp.annotation.Dependency;
import com.artillexstudios.axrewards.libs.lamp.annotation.Description;
import com.artillexstudios.axrewards.libs.lamp.annotation.Range;
import com.artillexstudios.axrewards.libs.lamp.annotation.dynamic.AnnotationReplacer;
import com.artillexstudios.axrewards.libs.lamp.autocomplete.AutoCompleter;
import com.artillexstudios.axrewards.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axrewards.libs.lamp.command.CommandActor;
import com.artillexstudios.axrewards.libs.lamp.command.CommandCategory;
import com.artillexstudios.axrewards.libs.lamp.command.CommandParameter;
import com.artillexstudios.axrewards.libs.lamp.command.CommandPermission;
import com.artillexstudios.axrewards.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axrewards.libs.lamp.core.BaseAutoCompleter;
import com.artillexstudios.axrewards.libs.lamp.core.BaseCommandCategory;
import com.artillexstudios.axrewards.libs.lamp.core.BaseCommandDispatcher;
import com.artillexstudios.axrewards.libs.lamp.core.BaseCommandHelp;
import com.artillexstudios.axrewards.libs.lamp.core.CommandExecutable;
import com.artillexstudios.axrewards.libs.lamp.core.CommandParser;
import com.artillexstudios.axrewards.libs.lamp.core.CommandPath;
import com.artillexstudios.axrewards.libs.lamp.core.CooldownCondition;
import com.artillexstudios.axrewards.libs.lamp.core.DependencyResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.core.EitherValueResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.core.EnumResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.core.LocalesAnnotationReplacer;
import com.artillexstudios.axrewards.libs.lamp.core.Resolver;
import com.artillexstudios.axrewards.libs.lamp.core.ResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.core.SenderContextResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.core.reflect.MethodCallerFactory;
import com.artillexstudios.axrewards.libs.lamp.exception.CommandExceptionHandler;
import com.artillexstudios.axrewards.libs.lamp.exception.DefaultExceptionHandler;
import com.artillexstudios.axrewards.libs.lamp.exception.InvalidBooleanException;
import com.artillexstudios.axrewards.libs.lamp.exception.InvalidURLException;
import com.artillexstudios.axrewards.libs.lamp.exception.InvalidUUIDException;
import com.artillexstudios.axrewards.libs.lamp.exception.NumberNotInRangeException;
import com.artillexstudios.axrewards.libs.lamp.exception.ThrowableFromCommand;
import com.artillexstudios.axrewards.libs.lamp.help.CommandHelp;
import com.artillexstudios.axrewards.libs.lamp.help.CommandHelpWriter;
import com.artillexstudios.axrewards.libs.lamp.locales.Translator;
import com.artillexstudios.axrewards.libs.lamp.orphan.OrphanCommand;
import com.artillexstudios.axrewards.libs.lamp.orphan.OrphanRegistry;
import com.artillexstudios.axrewards.libs.lamp.orphan.Orphans;
import com.artillexstudios.axrewards.libs.lamp.process.CommandCondition;
import com.artillexstudios.axrewards.libs.lamp.process.ContextResolver;
import com.artillexstudios.axrewards.libs.lamp.process.ContextResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.process.ParameterNamingStrategy;
import com.artillexstudios.axrewards.libs.lamp.process.ParameterResolver;
import com.artillexstudios.axrewards.libs.lamp.process.ParameterValidator;
import com.artillexstudios.axrewards.libs.lamp.process.PermissionReader;
import com.artillexstudios.axrewards.libs.lamp.process.ResponseHandler;
import com.artillexstudios.axrewards.libs.lamp.process.SenderResolver;
import com.artillexstudios.axrewards.libs.lamp.process.ValueResolver;
import com.artillexstudios.axrewards.libs.lamp.process.ValueResolverFactory;
import com.artillexstudios.axrewards.libs.lamp.util.ClassMap;
import com.artillexstudios.axrewards.libs.lamp.util.Preconditions;
import com.artillexstudios.axrewards.libs.lamp.util.Primitives;
import com.artillexstudios.axrewards.libs.lamp.util.StackTraceSanitizer;
import com.artillexstudios.axrewards.libs.lamp.util.Strings;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Internal
public abstract class BaseCommandHandler
implements CommandHandler {
    protected final Map<CommandPath, CommandExecutable> executables = new HashMap<CommandPath, CommandExecutable>();
    protected final Map<CommandPath, BaseCommandCategory> categories = new HashMap<CommandPath, BaseCommandCategory>();
    private final BaseCommandDispatcher dispatcher = new BaseCommandDispatcher(this);
    final List<ResolverFactory> factories = new ArrayList<ResolverFactory>();
    final BaseAutoCompleter autoCompleter = new BaseAutoCompleter(this);
    final ClassMap<List<ParameterValidator<Object>>> validators = new ClassMap();
    final ClassMap<ResponseHandler<?>> responseHandlers = new ClassMap();
    final ClassMap<Supplier<?>> dependencies = new ClassMap();
    final List<SenderResolver> senderResolvers = new ArrayList<SenderResolver>();
    private final Set<PermissionReader> permissionReaders = new HashSet<PermissionReader>();
    final Map<Class<?>, Set<AnnotationReplacer<?>>> annotationReplacers = new ClassMap();
    private MethodCallerFactory methodCallerFactory = MethodCallerFactory.defaultFactory();
    private final WrappedExceptionHandler exceptionHandler = new WrappedExceptionHandler(DefaultExceptionHandler.INSTANCE);
    private StackTraceSanitizer sanitizer = StackTraceSanitizer.defaultSanitizer();
    String flagPrefix = "-";
    String switchPrefix = "-";
    String messagePrefix = "";
    CommandHelpWriter<?> helpWriter;
    ParameterNamingStrategy parameterNamingStrategy = ParameterNamingStrategy.lowerCaseWithSpace();
    boolean failOnExtra = false;
    final List<CommandCondition> conditions = new ArrayList<CommandCondition>();
    private final Translator translator = Translator.create();

    public BaseCommandHandler() {
        this.registerContextResolverFactory(new SenderContextResolverFactory(this.senderResolvers));
        this.registerContextResolverFactory(DependencyResolverFactory.INSTANCE);
        this.registerValueResolverFactory(EitherValueResolverFactory.INSTANCE);
        this.registerValueResolver(Integer.TYPE, ValueResolver.ValueResolverContext::popInt);
        this.registerValueResolver(Double.TYPE, ValueResolver.ValueResolverContext::popDouble);
        this.registerValueResolver(Short.TYPE, ValueResolver.ValueResolverContext::popShort);
        this.registerValueResolver(Byte.TYPE, ValueResolver.ValueResolverContext::popByte);
        this.registerValueResolver(Long.TYPE, ValueResolver.ValueResolverContext::popLong);
        this.registerValueResolver(Float.TYPE, ValueResolver.ValueResolverContext::popFloat);
        this.registerValueResolver(Boolean.TYPE, this.bool());
        this.registerValueResolver(String.class, ValueResolver.ValueResolverContext::popForParameter);
        this.registerValueResolver(UUID.class, context -> {
            String value = context.pop();
            try {
                return UUID.fromString(value);
            }
            catch (Throwable t) {
                throw new InvalidUUIDException(context.parameter(), value);
            }
        });
        this.registerValueResolver(URL.class, context -> {
            String value = context.pop();
            try {
                return new URL(value);
            }
            catch (MalformedURLException e) {
                throw new InvalidURLException(context.parameter(), value);
            }
        });
        this.registerValueResolver(URI.class, context -> {
            String value = context.pop();
            try {
                return new URI(value);
            }
            catch (URISyntaxException e) {
                throw new InvalidURLException(context.parameter(), value);
            }
        });
        this.registerContextResolver(CommandHandler.class, context -> this);
        this.registerContextResolver(ExecutableCommand.class, context -> context.parameter().getDeclaringCommand());
        this.registerContextResolver(CommandActor.class, ParameterResolver.ParameterResolverContext::actor);
        this.registerContextResolver(CommandHelp.class, new BaseCommandHelp.Resolver(this));
        this.setExceptionHandler(DefaultExceptionHandler.INSTANCE);
        this.registerCondition(CooldownCondition.INSTANCE);
        this.registerParameterValidator(Number.class, (value, parameter, actor) -> {
            Range range = parameter.getAnnotation(Range.class);
            if (range != null && (value.doubleValue() > range.max() || value.doubleValue() < range.min())) {
                throw new NumberNotInRangeException(actor, parameter, (Number)value, range.min(), range.max());
            }
        });
        this.registerCondition((actor, command, arguments) -> command.checkPermission(actor));
        this.registerAnnotationReplacer(Description.class, new LocalesAnnotationReplacer(this));
    }

    @Override
    @NotNull
    public CommandHandler setParameterNamingStrategy(@NotNull ParameterNamingStrategy strategy) {
        Preconditions.notNull(strategy, "parameter naming strategy");
        this.parameterNamingStrategy = strategy;
        return this;
    }

    @Override
    @NotNull
    public ParameterNamingStrategy getParameterNamingStrategy() {
        return this.parameterNamingStrategy;
    }

    @Override
    @NotNull
    public CommandHandler register(Object ... commands) {
        for (Object command : commands) {
            Preconditions.notNull(command, "Command");
            if (command instanceof OrphanCommand) {
                throw new IllegalArgumentException("You cannot register an OrphanCommand directly! You must wrap it using Orphans.path(...).handler(OrphanCommand)");
            }
            if (command instanceof Orphans) {
                throw new IllegalArgumentException("You forgot to call .handler(OrphanCommand) in your Orphans.path(...)!");
            }
            if (command instanceof OrphanRegistry) {
                this.setDependencies(((OrphanRegistry)command).getHandler());
                CommandParser.parse(this, (OrphanRegistry)command);
                continue;
            }
            this.setDependencies(command);
            CommandParser.parse(this, command);
        }
        Iterator<BaseCommandCategory> iterator = this.categories.values().iterator();
        while (iterator.hasNext()) {
            BaseCommandCategory category;
            CommandPath categoryPath = (category = (BaseCommandCategory)iterator.next()).getPath().getCategoryPath();
            category.parent(categoryPath == null ? null : this.categories.get(categoryPath));
            this.findPermission(category.defaultAction);
        }
        for (CommandExecutable executable : this.executables.values()) {
            this.findPermission(executable);
        }
        return this;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return this.translator.getLocale();
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        this.translator.setLocale(locale);
    }

    @Override
    @NotNull
    public Translator getTranslator() {
        return this.translator;
    }

    private void findPermission(@Nullable CommandExecutable executable) {
        if (executable == null) {
            return;
        }
        if (!executable.permissionSet) {
            for (PermissionReader reader : this.permissionReaders) {
                CommandPermission p = reader.getPermission(executable);
                if (p == null) continue;
                executable.permissionSet = true;
                executable.setPermission(p);
                return;
            }
        }
    }

    public Set<PermissionReader> getPermissionReaders() {
        return this.permissionReaders;
    }

    @Override
    @NotNull
    public CommandHandler setMethodCallerFactory(@NotNull MethodCallerFactory factory) {
        Preconditions.notNull(factory, "method caller factory");
        this.methodCallerFactory = factory;
        return this;
    }

    @Override
    @NotNull
    public CommandHandler setExceptionHandler(@NotNull CommandExceptionHandler handler) {
        Preconditions.notNull(handler, "command exception handler");
        this.exceptionHandler.handler = handler;
        return this;
    }

    @Override
    @NotNull
    public <T extends Throwable> CommandHandler registerExceptionHandler(@NotNull Class<T> exceptionType, @NotNull BiConsumer<CommandActor, T> handler) {
        Preconditions.notNull(exceptionType, "exception type");
        Preconditions.notNull(handler, "exception handler");
        this.exceptionHandler.exceptionsHandlers.add(exceptionType, handler);
        return this;
    }

    @Override
    @NotNull
    public CommandHandler setSwitchPrefix(@NotNull String prefix) {
        Preconditions.notNull(prefix, "prefix");
        Preconditions.notEmpty(prefix, "prefix cannot be empty!");
        this.switchPrefix = prefix;
        return this;
    }

    @Override
    @NotNull
    public CommandHandler setFlagPrefix(@NotNull String prefix) {
        Preconditions.notNull(prefix, "prefix");
        Preconditions.notEmpty(prefix, "prefix cannot be empty!");
        this.flagPrefix = prefix;
        return this;
    }

    @Override
    @NotNull
    public CommandHandler setMessagePrefix(@NotNull String prefix) {
        Preconditions.notNull(prefix, "prefix");
        this.messagePrefix = prefix;
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler setHelpWriter(@NotNull CommandHelpWriter<T> helpWriter) {
        Preconditions.notNull(helpWriter, "command help writer");
        this.helpWriter = helpWriter;
        return this;
    }

    @Override
    @NotNull
    public CommandHandler disableStackTraceSanitizing() {
        this.sanitizer = StackTraceSanitizer.empty();
        return this;
    }

    @Override
    @NotNull
    public CommandHandler failOnTooManyArguments() {
        this.failOnExtra = true;
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerSenderResolver(@NotNull SenderResolver resolver) {
        Preconditions.notNull(resolver, "resolver");
        this.senderResolvers.add(resolver);
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerPermissionReader(@NotNull PermissionReader reader) {
        Preconditions.notNull(reader, "permission reader");
        this.permissionReaders.add(reader);
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerValueResolver(@NotNull Class<T> type, @NotNull ValueResolver<T> resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        if (type.isPrimitive()) {
            this.registerValueResolver(Primitives.wrap(type), resolver);
        }
        this.factories.add(new ResolverFactory(ValueResolverFactory.forType(type, resolver)));
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerValueResolver(int priority, @NotNull Class<T> type, @NotNull ValueResolver<T> resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        if (type.isPrimitive()) {
            this.registerValueResolver(priority, Primitives.wrap(type), resolver);
        }
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), new ResolverFactory(ValueResolverFactory.forType(type, resolver)));
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerContextResolver(@NotNull Class<T> type, @NotNull ContextResolver<T> resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        if (type.isPrimitive()) {
            this.registerContextResolver(Primitives.wrap(type), resolver);
        }
        this.factories.add(new ResolverFactory(ContextResolverFactory.forType(type, resolver)));
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerContextResolver(int priority, @NotNull Class<T> type, @NotNull ContextResolver<T> resolver) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(resolver, "resolver");
        if (type.isPrimitive()) {
            this.registerContextResolver(Primitives.wrap(type), resolver);
        }
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), new ResolverFactory(ContextResolverFactory.forType(type, resolver)));
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerContextValue(@NotNull Class<T> type, T value) {
        return this.registerContextResolver(type, ContextResolver.of(value));
    }

    @Override
    @NotNull
    public <T> CommandHandler registerContextValue(int priority, @NotNull Class<T> type, @NotNull T value) {
        return this.registerContextResolver(priority, type, ContextResolver.of(value));
    }

    @Override
    @NotNull
    public CommandHandler registerValueResolverFactory(@NotNull ValueResolverFactory factory) {
        Preconditions.notNull(factory, "value resolver factory");
        this.factories.add(new ResolverFactory(factory));
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerValueResolverFactory(int priority, @NotNull ValueResolverFactory factory) {
        Preconditions.notNull(factory, "value resolver factory");
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), new ResolverFactory(factory));
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerContextResolverFactory(@NotNull ContextResolverFactory factory) {
        Preconditions.notNull(factory, "context resolver factory");
        this.factories.add(new ResolverFactory(factory));
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerContextResolverFactory(int priority, @NotNull ContextResolverFactory factory) {
        Preconditions.notNull(factory, "context resolver factory");
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), new ResolverFactory(factory));
        return this;
    }

    @Override
    @NotNull
    public CommandHandler registerCondition(@NotNull CommandCondition condition) {
        Preconditions.notNull(condition, "condition");
        this.conditions.add(condition);
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerDependency(@NotNull Class<T> type, @NotNull Supplier<T> supplier) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(supplier, "supplier");
        this.dependencies.add(type, supplier);
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerDependency(@NotNull Class<T> type, T value) {
        Preconditions.notNull(type, "type");
        this.dependencies.add(type, () -> value);
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerParameterValidator(@NotNull Class<T> type, @NotNull ParameterValidator<T> validator) {
        Preconditions.notNull(type, "type");
        Preconditions.notNull(validator, "validator");
        this.validators.computeIfAbsent(Primitives.wrap(type), t -> new ArrayList()).add(validator);
        return this;
    }

    @Override
    @NotNull
    public <T> CommandHandler registerResponseHandler(@NotNull Class<T> responseType, @NotNull ResponseHandler<T> handler) {
        Preconditions.notNull(responseType, "response type");
        Preconditions.notNull(handler, "response handler");
        this.responseHandlers.add(responseType, handler);
        return this;
    }

    @Override
    @NotNull
    public <T extends Annotation> CommandHandler registerAnnotationReplacer(@NotNull Class<T> annotationType, @NotNull AnnotationReplacer<T> replacer) {
        Preconditions.notNull(annotationType, "annotation type");
        Preconditions.notNull(replacer, "annotation replacer");
        this.annotationReplacers.computeIfAbsent(annotationType, e -> new HashSet()).add(replacer);
        return this;
    }

    @Override
    @NotNull
    public CommandHandler accept(@NotNull CommandHandlerVisitor visitor) {
        Preconditions.notNull(visitor, "command handler visitor cannot be null!");
        visitor.visit(this);
        return this;
    }

    @Nullable
    public <T extends Annotation> List<Annotation> replaceAnnotation(AnnotatedElement element, T ann) {
        Set<AnnotationReplacer<?>> replacers = this.annotationReplacers.get(ann.annotationType());
        if (replacers == null || replacers.isEmpty()) {
            return null;
        }
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (AnnotationReplacer<?> replacer : replacers) {
            Collection<Annotation> replaced = replacer.replaceAnnotations(element, ann);
            if (replaced == null || replaced.isEmpty()) continue;
            annotations.addAll(replaced);
        }
        if (annotations.isEmpty()) {
            return null;
        }
        return annotations;
    }

    @Override
    @NotNull
    public AutoCompleter getAutoCompleter() {
        return this.autoCompleter;
    }

    @Override
    public ExecutableCommand getCommand(@NotNull CommandPath path) {
        return this.executables.get(path);
    }

    @Override
    public CommandCategory getCategory(@NotNull CommandPath path) {
        return this.categories.get(path);
    }

    @Override
    public @UnmodifiableView @NotNull Map<CommandPath, ExecutableCommand> getCommands() {
        return Collections.unmodifiableMap(this.executables);
    }

    @Override
    public @UnmodifiableView @NotNull Map<CommandPath, CommandCategory> getCategories() {
        return Collections.unmodifiableMap(this.categories);
    }

    public <T> ParameterResolver<T> getResolver(CommandParameter parameter) {
        for (ResolverFactory factory : this.factories) {
            Resolver resolver = factory.create(parameter);
            if (resolver == null) continue;
            return resolver;
        }
        if (parameter.getType().isEnum()) {
            return new Resolver(null, EnumResolverFactory.INSTANCE.create(parameter));
        }
        return null;
    }

    @Override
    @NotNull
    public CommandExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    @NotNull
    public MethodCallerFactory getMethodCallerFactory() {
        return this.methodCallerFactory;
    }

    @Override
    public <T> CommandHelpWriter<T> getHelpWriter() {
        return this.helpWriter;
    }

    private void unregister(CommandPath path, CommandExecutable command) {
        BaseCommandCategory parent = command.parent;
        if (parent != null) {
            parent.commands.remove(path);
            if (parent.isEmpty()) {
                this.categories.remove(parent.path);
            }
        }
    }

    private void unregister(CommandPath path, BaseCommandCategory category) {
        BaseCommandCategory parent = category.parent;
        if (parent != null) {
            parent.commands.remove(path);
            if (parent.isEmpty()) {
                this.categories.remove(parent.path);
            }
        }
    }

    @Override
    public boolean unregister(@NotNull CommandPath path) {
        Map.Entry<CommandPath, Comparable<ExecutableCommand>> entry;
        boolean modified = false;
        Iterator<Map.Entry<CommandPath, Comparable<ExecutableCommand>>> iterator = this.executables.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!entry.getKey().isChildOf(path)) continue;
            modified = true;
            iterator.remove();
            this.unregister(path, (CommandExecutable)entry.getValue());
        }
        iterator = this.categories.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!entry.getKey().isChildOf(path)) continue;
            modified = true;
            iterator.remove();
            this.unregister(path, (BaseCommandCategory)entry.getValue());
        }
        return modified;
    }

    @Override
    public boolean unregister(@NotNull String commandPath) {
        return this.unregister(CommandPath.get(Strings.splitBySpace(commandPath)));
    }

    @Override
    public void unregisterAllCommands() {
        this.getRootPaths().forEach(this::unregister);
    }

    @Override
    @NotNull
    public Set<CommandPath> getRootPaths() {
        HashSet<CommandPath> paths = new HashSet<CommandPath>();
        for (CommandPath path : this.categories.keySet()) {
            if (!path.isRoot()) continue;
            paths.add(path);
        }
        for (CommandPath path : this.executables.keySet()) {
            if (!path.isRoot()) continue;
            paths.add(path);
        }
        return paths;
    }

    @Override
    @NotNull
    public String getSwitchPrefix() {
        return this.switchPrefix;
    }

    @Override
    @NotNull
    public String getFlagPrefix() {
        return this.flagPrefix;
    }

    @Override
    @NotNull
    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    @Override
    public <T> @NotNull Optional<@Nullable T> dispatch(@NotNull CommandActor actor, @NotNull ArgumentStack arguments) {
        return Optional.ofNullable(this.dispatcher.eval(actor, arguments));
    }

    @Override
    public <T> @NotNull Optional<@Nullable T> dispatch(@NotNull CommandActor actor, @NotNull String commandInput) {
        try {
            return this.dispatch(actor, ArgumentStack.parse(commandInput));
        }
        catch (Throwable t) {
            this.getExceptionHandler().handleException(t, actor);
            return Optional.empty();
        }
    }

    @Override
    public <T> Supplier<T> getDependency(@NotNull Class<T> dependencyType) {
        return this.dependencies.getFlexible(dependencyType);
    }

    @Override
    public <T> Supplier<T> getDependency(@NotNull Class<T> dependencyType, Supplier<T> def) {
        return this.dependencies.getFlexibleOrDefault(dependencyType, def);
    }

    protected void setDependencies(Object ob) {
        for (Field field : Primitives.getType(ob).getDeclaredFields()) {
            Supplier<?> dependency2;
            if (!field.isAnnotationPresent(Dependency.class)) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((dependency2 = this.dependencies.getFlexible(field.getType())) == null) {
                throw new IllegalStateException("Unable to find correct dependency for type " + field.getType());
            }
            try {
                field.set(ob, dependency2.get());
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to inject dependency value into field " + field.getName(), e);
            }
        }
    }

    private ValueResolver<Boolean> bool() {
        return context -> {
            String v = context.pop();
            switch (v.toLowerCase()) {
                case "true": 
                case "yes": 
                case "ye": 
                case "y": 
                case "yeah": 
                case "ofcourse": 
                case "mhm": {
                    return true;
                }
                case "false": 
                case "no": 
                case "n": {
                    return false;
                }
            }
            throw new InvalidBooleanException(context.parameter(), v);
        };
    }

    private class WrappedExceptionHandler
    implements CommandExceptionHandler {
        private final ClassMap<BiConsumer<CommandActor, Throwable>> exceptionsHandlers = new ClassMap();
        @NotNull
        private CommandExceptionHandler handler;

        public WrappedExceptionHandler(CommandExceptionHandler handler) {
            this.handler = handler;
        }

        @Override
        public void handleException(@NotNull Throwable throwable, @NotNull CommandActor actor) {
            Throwable cause = throwable.getCause();
            if (cause != null && (cause.getClass().isAnnotationPresent(ThrowableFromCommand.class) || this.exceptionsHandlers.getFlexible(cause.getClass()) != null)) {
                throwable = cause;
            }
            @Nullable BiConsumer<CommandActor, Throwable> registered = this.exceptionsHandlers.getFlexible(throwable.getClass());
            BaseCommandHandler.this.sanitizer.sanitize(throwable);
            if (registered != null) {
                registered.accept(actor, throwable);
                return;
            }
            this.handler.handleException(throwable, actor);
        }
    }
}

