/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.lamp.core;

import com.artillexstudios.axrewards.libs.lamp.CommandHandler;
import com.artillexstudios.axrewards.libs.lamp.autocomplete.AutoCompleter;
import com.artillexstudios.axrewards.libs.lamp.autocomplete.SuggestionProvider;
import com.artillexstudios.axrewards.libs.lamp.autocomplete.SuggestionProviderFactory;
import com.artillexstudios.axrewards.libs.lamp.command.ArgumentStack;
import com.artillexstudios.axrewards.libs.lamp.command.CommandActor;
import com.artillexstudios.axrewards.libs.lamp.command.CommandCategory;
import com.artillexstudios.axrewards.libs.lamp.command.CommandParameter;
import com.artillexstudios.axrewards.libs.lamp.command.ExecutableCommand;
import com.artillexstudios.axrewards.libs.lamp.core.AutoCompleterAnnotationFactory;
import com.artillexstudios.axrewards.libs.lamp.core.BaseCommandHandler;
import com.artillexstudios.axrewards.libs.lamp.core.CommandPath;
import com.artillexstudios.axrewards.libs.lamp.core.EitherSuggestionProviderFactory;
import com.artillexstudios.axrewards.libs.lamp.core.EnumSuggestionProviderFactory;
import com.artillexstudios.axrewards.libs.lamp.core.MutableCommandPath;
import com.artillexstudios.axrewards.libs.lamp.util.Preconditions;
import com.artillexstudios.axrewards.libs.lamp.util.Primitives;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

final class BaseAutoCompleter
implements AutoCompleter {
    private final BaseCommandHandler handler;
    final Map<String, SuggestionProvider> suggestionKeys = new HashMap<String, SuggestionProvider>();
    final List<SuggestionProviderFactory> factories = new ArrayList<SuggestionProviderFactory>();
    private boolean filterToClosestInput = true;

    public BaseAutoCompleter(BaseCommandHandler handler) {
        this.handler = handler;
        this.registerSuggestion("nothing", SuggestionProvider.EMPTY);
        this.registerSuggestion("empty", SuggestionProvider.EMPTY);
        this.registerParameterSuggestions(Boolean.TYPE, SuggestionProvider.of("true", "false"));
        this.registerSuggestionFactory(new AutoCompleterAnnotationFactory(this.suggestionKeys));
        this.registerSuggestionFactory(EitherSuggestionProviderFactory.INSTANCE);
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, @NotNull SuggestionProvider provider) {
        Preconditions.notNull(provider, "provider ID");
        Preconditions.notNull(provider, "tab suggestion provider");
        this.suggestionKeys.put(providerID, provider);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, @NotNull Collection<String> completions) {
        Preconditions.notNull(providerID, "provider ID");
        Preconditions.notNull(completions, "completions");
        this.suggestionKeys.put(providerID, (args, sender, command) -> completions);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestion(@NotNull String providerID, String ... completions) {
        this.registerSuggestion(providerID, com.artillexstudios.axrewards.libs.lamp.util.Collections.listOf(completions));
        return this;
    }

    @Override
    public AutoCompleter registerParameterSuggestions(@NotNull Class<?> parameterType, @NotNull SuggestionProvider provider) {
        Preconditions.notNull(parameterType, "parameter type");
        Preconditions.notNull(provider, "provider");
        this.registerSuggestionFactory(SuggestionProviderFactory.forType(parameterType, provider));
        Class<?> wrapped = Primitives.wrap(parameterType);
        if (wrapped != parameterType) {
            this.registerSuggestionFactory(SuggestionProviderFactory.forType(wrapped, provider));
        }
        return this;
    }

    @Override
    public AutoCompleter registerParameterSuggestions(@NotNull Class<?> parameterType, @NotNull String providerID) {
        Preconditions.notNull(parameterType, "parameter type");
        Preconditions.notNull(providerID, "provider ID");
        SuggestionProvider provider = this.suggestionKeys.get(providerID);
        if (provider == null) {
            throw new IllegalArgumentException("No such tab provider: " + providerID + ". Available: " + this.suggestionKeys.keySet());
        }
        this.registerParameterSuggestions(parameterType, provider);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestionFactory(@NotNull SuggestionProviderFactory factory) {
        Preconditions.notNull(factory, "suggestion provider factory cannot be null!");
        this.factories.add(factory);
        return this;
    }

    @Override
    public AutoCompleter registerSuggestionFactory(int priority, @NotNull SuggestionProviderFactory factory) {
        Preconditions.notNull(factory, "suggestion provider factory cannot be null!");
        this.factories.add(Preconditions.coerceIn(priority, 0, this.factories.size()), factory);
        return this;
    }

    public SuggestionProvider getProvider(CommandParameter parameter) {
        if (parameter.isSwitch()) {
            return SuggestionProvider.of(this.handler.switchPrefix + parameter.getSwitchName());
        }
        for (SuggestionProviderFactory factory : this.factories) {
            SuggestionProvider provider = factory.createSuggestionProvider(parameter);
            if (provider == null) continue;
            return provider;
        }
        if (parameter.getType().isEnum()) {
            return EnumSuggestionProviderFactory.INSTANCE.createSuggestionProvider(parameter);
        }
        return SuggestionProvider.EMPTY;
    }

    @Override
    public SuggestionProvider getSuggestionProvider(@NotNull String id) {
        return this.suggestionKeys.get(id);
    }

    @Override
    public List<String> complete(@NotNull CommandActor actor, @NotNull ArgumentStack arguments) {
        CommandPath path = CommandPath.get(arguments.subList(0, arguments.size() - 1));
        int originalSize = arguments.size();
        ExecutableCommand command = this.searchForCommand(path, actor);
        if (command != null) {
            command.getPath().forEach(c2 -> {
                String cfr_ignored_0 = (String)arguments.removeFirst();
            });
            return this.getCompletions(actor, arguments, command);
        }
        CommandCategory category = this.getLastCategory(path);
        if (category == null) {
            return Collections.emptyList();
        }
        category.getPath().forEach(c2 -> {
            String cfr_ignored_0 = (String)arguments.removeFirst();
        });
        return this.getCompletions(actor, arguments, category, originalSize);
    }

    @Override
    public List<String> complete(@NotNull CommandActor actor, @NotNull String buffer) {
        return this.complete(actor, ArgumentStack.parseForAutoCompletion(buffer));
    }

    @Override
    public void filterToClosestInput(boolean filterToClosestInput) {
        this.filterToClosestInput = filterToClosestInput;
    }

    private ExecutableCommand searchForCommand(CommandPath path, CommandActor actor) {
        ExecutableCommand found = this.handler.getCommand(path);
        if (found != null && !found.isSecret() && found.getPermission().canExecute(actor)) {
            return found;
        }
        MutableCommandPath mpath = MutableCommandPath.empty();
        for (String p : path) {
            mpath.add(p);
            found = this.handler.getCommand(mpath);
            if (found == null || found.isSecret() || !found.getPermission().canExecute(actor)) continue;
            return found;
        }
        return null;
    }

    private CommandCategory getLastCategory(CommandPath path) {
        MutableCommandPath mpath = MutableCommandPath.empty();
        CommandCategory category = null;
        for (String p : path) {
            mpath.add(p);
            CommandCategory c2 = this.handler.getCategory(mpath);
            if (c2 == null && category != null) {
                return category;
            }
            if (c2 == null) continue;
            category = c2;
        }
        return category;
    }

    private List<String> getCompletions(CommandActor actor, ArgumentStack args, @NotNull ExecutableCommand command) {
        try {
            if (args.isEmpty()) {
                return Collections.emptyList();
            }
            if (command.getValueParameters().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<CommandParameter> parameters = new ArrayList<CommandParameter>(command.getValueParameters().values());
            Collections.sort(parameters);
            for (CommandParameter parameter : parameters) {
                try {
                    if (parameter.isFlag() || parameter.getCommandIndex() != args.size() - 1) continue;
                    if (!parameter.getPermission().canExecute(actor)) {
                        return Collections.emptyList();
                    }
                    SuggestionProvider provider = parameter.getSuggestionProvider();
                    Preconditions.notNull(provider, "provider must not be null!");
                    return this.getParamCompletions(provider.getSuggestions(args, actor, command), args);
                }
                catch (Throwable provider) {
                }
            }
            parameters.removeIf(c2 -> !c2.isFlag());
            if (parameters.isEmpty()) {
                return Collections.emptyList();
            }
            Optional<CommandParameter> currentFlag = parameters.stream().filter(c2 -> {
                int index = args.indexOf(this.handler.getFlagPrefix() + c2.getFlagName());
                return index == args.size() - 2;
            }).findFirst();
            if (currentFlag.isPresent()) {
                SuggestionProvider provider = currentFlag.get().getSuggestionProvider();
                return this.getParamCompletions(provider.getSuggestions(args, actor, command), args);
            }
            for (CommandParameter flag : parameters) {
                int index = args.indexOf(this.handler.getFlagPrefix() + flag.getFlagName());
                if (index == -1) {
                    return com.artillexstudios.axrewards.libs.lamp.util.Collections.listOf(this.handler.getFlagPrefix() + flag.getFlagName());
                }
                if (index != args.size() - 2) continue;
                return this.getParamCompletions(flag.getSuggestionProvider().getSuggestions(args, actor, command), args);
            }
            return Collections.emptyList();
        }
        catch (IndexOutOfBoundsException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    private List<String> getParamCompletions(Collection<String> provider, ArgumentStack args) {
        return provider.stream().filter(c2 -> !this.filterToClosestInput || c2.toLowerCase().startsWith(((String)args.getLast()).toLowerCase())).sorted(String.CASE_INSENSITIVE_ORDER).distinct().collect(Collectors.toList());
    }

    private List<String> getCompletions(CommandActor actor, @Unmodifiable ArgumentStack args, CommandCategory category, int originalSize) {
        ExecutableCommand defaultAction;
        if (args.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> suggestions = new HashSet<String>();
        if (category.getDefaultAction() != null && !(defaultAction = category.getDefaultAction()).isSecret() && defaultAction.getPermission().canExecute(actor)) {
            suggestions.addAll(this.getCompletions(actor, args, defaultAction));
        }
        if (originalSize - category.getPath().size() == 1) {
            category.getCommands().values().forEach(c2 -> {
                if (!c2.isSecret() && c2.getPermission().canExecute(actor)) {
                    suggestions.add(c2.getName());
                }
            });
            category.getCategories().values().forEach(c2 -> {
                if (!c2.isSecret() && c2.getPermission().canExecute(actor)) {
                    suggestions.add(c2.getName());
                }
            });
        }
        return this.getParamCompletions(suggestions, args);
    }

    @Override
    public CommandHandler and() {
        return this.handler;
    }
}

