/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.utils.logging;

import com.artillexstudios.axrewards.libs.axapi.utils.logging.DebugMode;
import com.artillexstudios.axrewards.libs.axapi.utils.logging.FileLogger;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogUtils {
    private static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final FileLogger fileLogger = new FileLogger("debug-logs");

    public static void debug(String message, DebugMode mode) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, mode);
    }

    public static void debug(String message) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, DebugMode.ALL);
    }

    public static void debug(Logger logger, String message, DebugMode mode) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message);
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            fileLogger.log(message);
        }
    }

    public static void debug(String message, Object object, DebugMode mode) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, mode);
    }

    public static void debug(String message, Object object) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, DebugMode.ALL);
    }

    public static void debug(Logger logger, String message, Object object, DebugMode mode) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message, object);
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
            fileLogger.log(formatted);
        }
    }

    public static void debug(String message, Object object, Object object2, DebugMode mode) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, mode);
    }

    public static void debug(String message, Object object, Object object2) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, DebugMode.ALL);
    }

    public static void debug(Logger logger, String message, Object object, Object object2, DebugMode mode) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message, object, object2);
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
            fileLogger.log(formatted);
        }
    }

    public static void debug(String message, Object object, Object object2, Object object3) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, object3, DebugMode.ALL);
    }

    public static void debug(String message, Object object, Object object2, Object object3, DebugMode mode) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, object3, mode);
    }

    public static void debug(Logger logger, String message, Object object, Object object2, Object object3, DebugMode mode) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message, new Object[]{object, object2, object3});
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object3 == null ? "null" : object3.toString()), (int)1);
            fileLogger.log(formatted);
        }
    }

    public static void debug(String message, Object object, Object object2, Object object3, Object object4) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, object3, object4, DebugMode.ALL);
    }

    public static void debug(String message, Object object, Object object2, Object object3, Object object4, DebugMode mode) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, object, object2, object3, object4, mode);
    }

    public static void debug(Logger logger, String message, Object object, Object object2, Object object3, Object object4, DebugMode mode) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message, new Object[]{object, object2, object3, object4});
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            String formatted = StringUtils.replace((String)message, (String)"{}", (String)(object == null ? "null" : object.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object2 == null ? "null" : object2.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object3 == null ? "null" : object3.toString()), (int)1);
            formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(object4 == null ? "null" : object4.toString()), (int)1);
            fileLogger.log(formatted);
        }
    }

    public static void debug(String message, DebugMode mode, Object ... arguments) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, mode, arguments);
    }

    public static void debug(String message, Object ... arguments) {
        LogUtils.debug(LoggerFactory.getLogger(STACK_WALKER.getCallerClass()), message, DebugMode.ALL, arguments);
    }

    public static void debug(Logger logger, String message, DebugMode mode, Object ... arguments) {
        if (mode == DebugMode.CONSOLE || mode == DebugMode.ALL) {
            logger.info(message, arguments);
        }
        if (mode == DebugMode.FILE || mode == DebugMode.ALL) {
            String formatted = message;
            for (Object argument : arguments) {
                formatted = StringUtils.replace((String)formatted, (String)"{}", (String)(argument == null ? "null" : argument.toString()), (int)1);
            }
            fileLogger.log(formatted);
        }
    }

    public static void warn(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).warn(message, arguments);
    }

    public static void error(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).error(message, arguments);
    }

    public static void info(String message, Object ... arguments) {
        LoggerFactory.getLogger(STACK_WALKER.getCallerClass()).info(message, arguments);
    }

    public static Logger logger() {
        return LoggerFactory.getLogger(STACK_WALKER.getCallerClass());
    }
}

