/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.updatechecker.sources;

import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.external.biz.base64Coder.Base64Coder;
import com.artillexstudios.axrewards.libs.axapi.updatechecker.ArtifactVersion;
import com.artillexstudios.axrewards.libs.axapi.updatechecker.Changelog;
import com.artillexstudios.axrewards.libs.axapi.updatechecker.UpdateCheck;
import com.artillexstudios.axrewards.libs.axapi.updatechecker.UpdateCheckResult;
import com.artillexstudios.axrewards.libs.axapi.updatechecker.sources.UpdateCheckSource;
import com.artillexstudios.axrewards.libs.axapi.utils.http.Requests;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SpigetUpdateCheckSource
implements UpdateCheckSource {
    private final int id;
    private final Gson gson = new Gson();

    public SpigetUpdateCheckSource(int id) {
        this.id = id;
    }

    @Override
    public UpdateCheck check(ArtifactVersion current) {
        try {
            HttpResponse<String> response = Requests.get("https://api.spiget.org/v2/resources/" + this.id + " /updates?size=300&sort=-id", Map.of());
            if (response.statusCode() != 200) {
                return new UpdateCheck(UpdateCheckResult.FAILED, current, List.of(), new RuntimeException("Received statuscode: " + response.statusCode()));
            }
            String body = response.body().toString();
            ArrayList<Changelog> changelogs = new ArrayList<Changelog>();
            JsonArray obj = (JsonArray)this.gson.fromJson(body, JsonArray.class);
            ArtifactVersion latest = new ArtifactVersion(obj.get(0).getAsJsonObject().get("title").getAsString());
            for (JsonElement jsonElement : obj) {
                JsonObject object = jsonElement.getAsJsonObject();
                ArtifactVersion version = new ArtifactVersion(object.get("title").getAsString());
                if (version.version() > current.version()) {
                    changelogs.add(new Changelog(version, new String(Base64Coder.decode(object.get("description").getAsString()))));
                    continue;
                }
                if (version.version() != current.version()) continue;
                break;
            }
            return new UpdateCheck(latest.version() > current.version() ? UpdateCheckResult.UPDATE_AVAILABLE : (latest.version() == current.version() ? UpdateCheckResult.UP_TO_DATE : UpdateCheckResult.DEV_VERSION), latest, changelogs);
        }
        catch (Exception e) {
            return new UpdateCheck(UpdateCheckResult.FAILED, current, List.of(), e);
        }
    }
}

