/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.database;

import com.artillexstudios.axrewards.libs.axapi.database.DatabaseType;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;

public class DatabaseTypes {
    private static DatabaseType defaultType;
    private static final Object2ObjectArrayMap<String, DatabaseType> registry;

    public static DatabaseType defaultType() {
        return defaultType;
    }

    public static DatabaseType register(DatabaseType type) {
        return DatabaseTypes.register(type, false);
    }

    public static DatabaseType register(DatabaseType type, boolean def) {
        registry.put((Object)type.name(), (Object)type);
        if (def) {
            defaultType = type;
        }
        return type;
    }

    public static DatabaseType fetch(String name) {
        for (Map.Entry entry : registry.entrySet()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(name)) continue;
            return (DatabaseType)entry.getValue();
        }
        return null;
    }

    public static List<String> keys() {
        return registry.keySet().stream().toList();
    }

    static {
        registry = new Object2ObjectArrayMap();
    }
}

