/*
 * Decompiled with CFR 0.152.
 */
package com.artillexstudios.axrewards.libs.axapi.config;

import com.artillexstudios.axrewards.libs.axapi.config.ConfigurationUpdater;
import com.artillexstudios.axrewards.libs.axapi.config.YamlConstructor;
import com.artillexstudios.axrewards.libs.axapi.config.adapters.MapConfigurationGetter;
import com.artillexstudios.axrewards.libs.axapi.config.adapters.TypeAdapter;
import com.artillexstudios.axrewards.libs.axapi.config.adapters.other.ObjectAdapter;
import com.artillexstudios.axrewards.libs.axapi.config.annotation.Comment;
import com.artillexstudios.axrewards.libs.axapi.config.annotation.ConfigurationPart;
import com.artillexstudios.axrewards.libs.axapi.config.annotation.Serializable;
import com.artillexstudios.axrewards.libs.axapi.config.reader.ClassConfigurationReader;
import com.artillexstudios.axrewards.libs.axapi.config.reader.FileConfigurationReader;
import com.artillexstudios.axrewards.libs.axapi.config.reader.Handler;
import com.artillexstudios.axrewards.libs.axapi.config.renamer.KeyRenamer;
import com.artillexstudios.axrewards.libs.axapi.config.renamer.LowerKebabCaseRenamer;
import com.artillexstudios.axrewards.libs.axapi.config.service.Formatter;
import com.artillexstudios.axrewards.libs.axapi.config.service.Writer;
import com.artillexstudios.axrewards.libs.axapi.config.service.implementation.FileCreator;
import com.artillexstudios.axrewards.libs.axapi.config.service.implementation.FileWriter;
import com.artillexstudios.axrewards.libs.axapi.config.service.implementation.YamlFormatter;
import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.DumperOptions;
import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.LoaderOptions;
import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.Yaml;
import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.constructor.BaseConstructor;
import com.artillexstudios.axrewards.libs.axapi.libs.snakeyaml.representer.Representer;
import com.artillexstudios.axrewards.libs.axapi.reflection.ClassUtils;
import com.artillexstudios.axrewards.libs.axapi.utils.UncheckedUtils;
import com.artillexstudios.axrewards.libs.axapi.utils.logging.LogUtils;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public final class YamlConfiguration<T extends ConfigurationPart>
extends MapConfigurationGetter {
    private final LinkedHashMap<String, Object> contents;
    private final Map<String, Comment> comments = new HashMap<String, Comment>();
    private final Builder<T> builder;
    private final YamlConstructor constructor;
    private final FileCreator creator;
    private final Handler reader;
    private final Yaml yaml;

    YamlConfiguration(Builder<T> builder) {
        super(new LinkedHashMap());
        this.contents = (LinkedHashMap)UncheckedUtils.unsafeCast(this.wrapped());
        this.builder = builder;
        this.creator = new FileCreator(this.builder.writer);
        this.constructor = new YamlConstructor(builder.loaderOptions);
        this.holder.registerAdapters(builder.adapters);
        this.yaml = new Yaml((BaseConstructor)this.constructor, new Representer(builder.dumperOptions), builder.dumperOptions, builder.loaderOptions);
        this.reader = this.builder.clazz == null ? new FileConfigurationReader(this.yaml, this.constructor, this.holder) : new ClassConfigurationReader(this.yaml, this.constructor, this.holder, this.builder.keyRenamer, this.builder.clazz);
    }

    public static <T extends ConfigurationPart> Builder<T> of(Path path, Class<T> clazz) {
        return new Builder<T>(path, clazz);
    }

    public static Builder<?> of(Path path) {
        return new Builder(path, null);
    }

    public boolean load() {
        boolean createFile = this.creator.create(this.builder.path, this.builder.defaults);
        if (!createFile) {
            return false;
        }
        if (this.builder.configVersionPath != null && this.runUpdaters()) {
            this.save();
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.builder.path.toFile()));){
            Pair<Map<String, Object>, Map<String, Comment>> read = this.reader.read(bufferedInputStream, null);
            this.contents.putAll((Map)read.first());
            this.comments.putAll((Map)read.second());
        }
        catch (IOException exception) {
            return false;
        }
        this.save();
        return true;
    }

    public T create(T instance) {
        boolean createFile = this.creator.create(this.builder.path, this.builder.defaults);
        if (!createFile) {
            return null;
        }
        if (this.builder.configVersionPath != null && this.runUpdaters()) {
            this.save();
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.builder.path.toFile()));){
            Pair<Map<String, Object>, Map<String, Comment>> read = this.reader.read(bufferedInputStream, instance);
            this.contents.putAll((Map)read.first());
            this.comments.putAll((Map)read.second());
        }
        catch (IOException exception) {
            return null;
        }
        this.save();
        return instance;
    }

    public T create() {
        return (T)this.create((ConfigurationPart)ClassUtils.INSTANCE.create(this.builder.clazz, new Object[0]));
    }

    public boolean save() {
        return this.builder.writer.write(this.builder.path, this.builder.formatter.format(this.reader.write(this.contents, this.comments)));
    }

    public void move(String path, String newPath) {
        Object previous = this.get(path);
        this.remove(path);
        this.set(newPath, previous);
    }

    public void set(String path, Object value) {
        if (this.builder.clazz == null) {
            value = this.holder.serialize(value, null);
        }
        this.set0(this.contents, path, value);
    }

    public Path path() {
        return this.builder.path;
    }

    private void set0(Map<String, Object> map, String path, Object value) {
        String[] route = path.split("\\.");
        if (route.length == 1) {
            map.put(route[0], value);
        } else {
            int i = 0;
            Map<String, Object> parent = map;
            while (i < route.length) {
                Map node;
                LinkedHashMap found = parent.get(route[i]);
                if (found == null) {
                    found = node = new LinkedHashMap();
                    parent.put(route[i], node);
                }
                if (!(found instanceof Map)) {
                    LogUtils.warn("Expected map class, but in reality it was: {}. Value: {}. Route: {} Full path: {}", found.getClass(), found, route[i], path);
                    return;
                }
                node = (Map)UncheckedUtils.unsafeCast(found);
                parent = node;
                if (++i != route.length - 1) continue;
                parent.put(route[i], value);
                break;
            }
        }
    }

    public <Z> Z get(String path, Class<Z> clazz) {
        if (this.builder.clazz == null) {
            return clazz.cast(this.holder.deserialize(this.get(path), clazz));
        }
        return clazz.cast(this.get(path));
    }

    public Object get(String path) {
        return this.get0(this.contents, path);
    }

    public String dumpInternalData() {
        return this.dumpInternalData0(this.contents);
    }

    private String dumpInternalData0(Map<?, ?> map) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                Map m = (Map)obj;
                builder.append(entry.getKey()).append("=").append(this.dumpInternalData0(m)).append(";class=").append(m.getClass()).append("\n");
                continue;
            }
            builder.append(entry.getKey()).append(entry.getValue()).append(";class=").append(entry.getValue().getClass()).append("\n");
        }
        return builder.toString();
    }

    private Object get0(Map<String, Object> map, String path) {
        String[] route = path.split("\\.");
        if (route.length == 1) {
            return map.get(route[0]);
        }
        int i = 0;
        Map parent = map;
        while (i < route.length) {
            Object found = parent.get(route[i]);
            if (found == null) {
                return null;
            }
            if (!(found instanceof Map)) {
                LogUtils.warn("Expected map class, but in reality it was: {}. Value: {}. Route: {} Full path: {}", found.getClass(), found, route[i], path);
                return null;
            }
            Map mapNode = (Map)found;
            parent = (Map)UncheckedUtils.unsafeCast(mapNode);
            if (++i != route.length - 1) continue;
            return parent.get(route[i]);
        }
        return null;
    }

    public void remove(String path) {
        String[] route = path.split("\\.");
        if (route.length == 1) {
            this.contents.remove(route[0]);
            return;
        }
        int i = 0;
        LinkedHashMap<String, Object> parent = this.contents;
        while (i < route.length) {
            LinkedHashMap node = (LinkedHashMap)UncheckedUtils.unsafeCast(parent.get(route[i]));
            if (node == null) {
                node = new LinkedHashMap();
                parent.put(route[i], node);
            }
            parent = node;
            if (++i != route.length - 1) continue;
            parent.remove(route[i]);
            break;
        }
    }

    private boolean runUpdaters() {
        Integer configVersion = this.getInteger(this.builder.configVersionPath);
        configVersion = configVersion == null ? 1 : configVersion;
        if (configVersion == this.builder.configVersion) {
            return false;
        }
        for (Map.Entry<IntIntPair, ConfigurationUpdater> entry : this.builder.updaters.entrySet()) {
            if (entry.getKey().firstInt() != configVersion.intValue()) continue;
            entry.getValue().update(this);
            configVersion = entry.getKey().secondInt();
            this.set(this.builder.configVersionPath, configVersion);
        }
        return true;
    }

    public static class Builder<T extends ConfigurationPart> {
        private final Path path;
        private final Class<T> clazz;
        private final Map<IntIntPair, ConfigurationUpdater> updaters = new LinkedHashMap<IntIntPair, ConfigurationUpdater>();
        private final Map<Class<?>, TypeAdapter<?, ?>> adapters = new HashMap();
        private InputStream defaults;
        private final DumperOptions dumperOptions = new DumperOptions();
        private final LoaderOptions loaderOptions = new LoaderOptions();
        private Formatter formatter = new YamlFormatter();
        private Writer writer = new FileWriter();
        private KeyRenamer keyRenamer = new LowerKebabCaseRenamer();
        private int configVersion = 0;
        private String configVersionPath = null;

        private Builder(Path path, Class<T> clazz) {
            this.path = path;
            this.clazz = clazz;
            this.dumperOptions.setProcessComments(true);
            this.loaderOptions.setProcessComments(true);
        }

        public Builder<T> addUpdater(int fromVersion, int toVersion, ConfigurationUpdater updater) {
            this.updaters.put(IntIntPair.of((int)fromVersion, (int)toVersion), updater);
            return this;
        }

        public Builder<T> withDefaults(InputStream defaults) {
            this.defaults = defaults;
            return this;
        }

        public Builder<T> withDumperOptions(Consumer<DumperOptions> dumperOptions) {
            dumperOptions.accept(this.dumperOptions);
            return this;
        }

        public Builder<T> withLoaderOptions(Consumer<LoaderOptions> loaderOptions) {
            loaderOptions.accept(this.loaderOptions);
            return this;
        }

        public Builder<T> configVersion(int configVersion, String configVersionPath) {
            this.configVersion = configVersion;
            this.configVersionPath = configVersionPath;
            return this;
        }

        public Builder<T> registerAdapter(Class<?> clazz, TypeAdapter<?, ?> adapter) {
            this.adapters.put(clazz, adapter);
            return this;
        }

        public Builder<T> withKeyRenamer(KeyRenamer keyRenamer) {
            this.keyRenamer = keyRenamer;
            return this;
        }

        public Builder<T> withFormatter(Formatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public Builder<T> withWriter(Writer writer) {
            this.writer = writer;
            return this;
        }

        public KeyRenamer keyRenamer() {
            return this.keyRenamer;
        }

        public YamlConfiguration<T> build() {
            this.adapters.put(Serializable.class, new ObjectAdapter(this));
            return new YamlConfiguration(this);
        }
    }
}

